/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy;

import com.liferay.gradle.plugins.soy.BuildSoyTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;

public class SoyPlugin
implements Plugin<Project> {
    public static final String BUILD_SOY_TASK_NAME = "buildSoy";

    public void apply(Project project) {
        this.addTaskBuildSoy(project);
    }

    protected BuildSoyTask addTaskBuildSoy(final Project project) {
        BuildSoyTask buildSoyTask = (BuildSoyTask)GradleUtil.addTask((Project)project, (String)BUILD_SOY_TASK_NAME, BuildSoyTask.class);
        buildSoyTask.setDescription("Compiles Closure Templates into JavaScript functions.");
        buildSoyTask.setGroup("build");
        buildSoyTask.setClasspath(new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                return sourceSet.getCompileClasspath();
            }
        });
        buildSoyTask.setIncludes(Collections.singleton("**/*.soy"));
        buildSoyTask.setSource(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return SoyPlugin.this.getResourcesDir(project);
            }
        });
        return buildSoyTask;
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

