/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy;

import java.io.File;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class BuildSoyTask
extends SourceTask {
    private Object _classpath;

    @TaskAction
    public void buildSoy() {
        Project project = this.getProject();
        project.javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.args(new Object[]{"--outputPathFormat", "{INPUT_DIRECTORY}/{INPUT_FILE_NAME}.js"});
                javaExecSpec.args(new Object[]{"--srcs", BuildSoyTask.this.getSourceFileNames()});
                javaExecSpec.setClasspath(BuildSoyTask.this.getClasspath());
                javaExecSpec.setMain("com.google.template.soy.SoyToJsSrcCompiler");
            }
        });
    }

    public FileCollection getClasspath() {
        Project project = this.getProject();
        return project.files(new Object[]{this._classpath});
    }

    @OutputFiles
    public Iterable<File> getOutputFiles() {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (File sourceFile : this.getSource()) {
            String fileName = sourceFile.getName();
            File outputFile = new File(sourceFile.getParentFile(), fileName + ".js");
            outputFiles.add(outputFile);
        }
        return outputFiles;
    }

    public void setClasspath(Object classpath) {
        this._classpath = classpath;
    }

    protected String getSourceFileNames() {
        FileTree sourceFiles = this.getSource();
        if (sourceFiles.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Project project = this.getProject();
        for (File sourceFile : sourceFiles) {
            sb.append(project.relativePath((Object)sourceFile));
            sb.append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

