/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.CollectionUtils;

public class FormatSourceTask
extends JavaExec {
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public FormatSourceTask() {
        this.setMain("com.liferay.source.formatter.SourceFormatter");
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceFormatterArgs.getBaseDirName());
    }

    public String getBaseDirName() {
        return this._sourceFormatterArgs.getBaseDirName();
    }

    public File getCopyrightFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceFormatterArgs.getCopyrightFileName());
    }

    public String getCopyrightFileName() {
        return this._sourceFormatterArgs.getCopyrightFileName();
    }

    public List<String> getFileNames() {
        return this._sourceFormatterArgs.getFileNames();
    }

    public FileCollection getFiles() {
        Project project = this.getProject();
        List<String> fileNames = this._sourceFormatterArgs.getFileNames();
        if (fileNames == null) {
            fileNames = Collections.emptyList();
        }
        return project.files(new Object[]{fileNames});
    }

    public int getMaxLineLength() {
        return this._sourceFormatterArgs.getMaxLineLength();
    }

    public int getProcessorThreadCount() {
        return this._sourceFormatterArgs.getProcessorThreadCount();
    }

    public boolean isAutoFix() {
        return this._sourceFormatterArgs.isAutoFix();
    }

    public boolean isFormatCurrentBranch() {
        return this._sourceFormatterArgs.isFormatCurrentBranch();
    }

    public boolean isFormatLatestAuthor() {
        return this._sourceFormatterArgs.isFormatLatestAuthor();
    }

    public boolean isFormatLocalChanges() {
        return this._sourceFormatterArgs.isFormatLocalChanges();
    }

    public boolean isPrintErrors() {
        return this._sourceFormatterArgs.isPrintErrors();
    }

    public boolean isThrowException() {
        return this._sourceFormatterArgs.isThrowException();
    }

    public boolean isUseProperties() {
        return this._sourceFormatterArgs.isUseProperties();
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDirName(String baseDirName) {
        this._sourceFormatterArgs.setBaseDirName(baseDirName);
    }

    public void setCopyrightFileName(String copyrightFileName) {
        this._sourceFormatterArgs.setCopyrightFileName(copyrightFileName);
    }

    public void setFileNames(Iterable<String> fileNames) {
        this._sourceFormatterArgs.setFileNames(CollectionUtils.toStringList(fileNames));
    }

    public void setFileNames(String ... fileNames) {
        this.setFileNames(Arrays.asList(fileNames));
    }

    public void setFormatCurrentBranch(boolean formatCurrentBranch) {
        this._sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setMaxLineLength(int maxLineLength) {
        this._sourceFormatterArgs.setMaxLineLength(maxLineLength);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setProcessorThreadCount(int processorThreadCount) {
        this._sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }

    public void setUseProperties(boolean useProperties) {
        this._sourceFormatterArgs.setUseProperties(useProperties);
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("format.current.branch=" + this.isFormatCurrentBranch());
        args.add("format.latest.author=" + this.isFormatLatestAuthor());
        args.add("format.local.changes=" + this.isFormatLocalChanges());
        args.add("max.line.length=" + this.getMaxLineLength());
        args.add("processor.thread.count=" + this.getProcessorThreadCount());
        args.add("source.auto.fix=" + this.isAutoFix());
        args.add("source.copyright.file=" + FileUtil.relativize((File)this.getCopyrightFile(), (File)this.getWorkingDir()));
        args.add("source.print.errors=" + this.isPrintErrors());
        args.add("source.throw.exception=" + this.isThrowException());
        args.add("source.use.properties=" + this.isUseProperties());
        FileCollection fileCollection = this.getFiles();
        if (fileCollection.isEmpty()) {
            args.add("source.base.dir=" + FileUtil.relativize((File)this.getBaseDir(), (File)this.getWorkingDir()));
        } else {
            args.add("source.files=" + this._merge((Iterable<File>)fileCollection, this.getWorkingDir()));
        }
        return args;
    }

    private String _merge(Iterable<File> files, File startFile) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (File file : files) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(FileUtil.relativize((File)file, (File)startFile));
            ++i;
        }
        return sb.toString();
    }
}

