/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.service.builder;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.portal.tools.service.builder.ServiceBuilderArgs;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.util.CollectionUtils;

@CacheableTask
public class BuildServiceTask
extends JavaExec {
    private Object _apiDir;
    private boolean _autoImportDefaultReferences = true;
    private boolean _autoNamespaceTables = true;
    private Object _beanLocatorUtil = "com.liferay.util.bean.PortletBeanLocatorUtil";
    private long _buildNumber = 1L;
    private boolean _buildNumberIncrement = true;
    private int _databaseNameMaxLength = 30;
    private Object _hbmFile;
    private Object _implDir;
    private final Set<String> _incubationFeatures = new HashSet<String>();
    private Object _inputFile;
    private final Set<Object> _modelHintsConfigs = new LinkedHashSet<Object>();
    private Object _modelHintsFile;
    private boolean _osgiModule;
    private Object _pluginName;
    private Object _propsUtil;
    private final Set<Object> _readOnlyPrefixes = new HashSet<Object>();
    private final Set<Object> _resourceActionsConfigs = new LinkedHashSet<Object>();
    private Object _resourcesDir;
    private Object _springFile;
    private final Set<Object> _springNamespaces = new LinkedHashSet<Object>();
    private Object _sqlDir;
    private Object _sqlFileName = "tables.sql";
    private Object _sqlIndexesFileName = "indexes.sql";
    private Object _sqlSequencesFileName = "sequences.sql";
    private Object _targetEntityName;
    private Object _testDir;
    private Object _uadDir;
    private Object _uadTestIntegrationDir;

    public BuildServiceTask() {
        this.modelHintsConfigs(ServiceBuilderArgs.MODEL_HINTS_CONFIGS);
        this.readOnlyPrefixes(ServiceBuilderArgs.READ_ONLY_PREFIXES);
        this.resourceActionsConfigs(ServiceBuilderArgs.RESOURCE_ACTION_CONFIGS);
        this.setMain("com.liferay.portal.tools.service.builder.ServiceBuilder");
        this.springNamespaces("beans");
        this.systemProperty("file.encoding", StandardCharsets.UTF_8.name());
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getApiDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._apiDir);
    }

    @Input
    public String getBeanLocatorUtil() {
        return GradleUtil.toString((Object)this._beanLocatorUtil);
    }

    @Input
    public long getBuildNumber() {
        return this._buildNumber;
    }

    @Input
    public int getDatabaseNameMaxLength() {
        return this._databaseNameMaxLength;
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getHbmFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._hbmFile);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getImplDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._implDir);
    }

    @Input
    @Optional
    public Set<String> getIncubationFeatures() {
        return this._incubationFeatures;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._inputFile);
    }

    public List<String> getJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        JavaVersion javaVersion = this.getJavaVersion();
        if (javaVersion.isJava9Compatible()) {
            jvmArgs.add("--illegal-access=permit");
        }
        return jvmArgs;
    }

    @Input
    public List<String> getModelHintsConfigs() {
        return GradleUtil.toStringList(this._modelHintsConfigs);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getModelHintsFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._modelHintsFile);
    }

    @Input
    public String getPluginName() {
        return GradleUtil.toString((Object)this._pluginName);
    }

    @Input
    public String getPropsUtil() {
        return GradleUtil.toString((Object)this._propsUtil);
    }

    @Input
    public List<String> getReadOnlyPrefixes() {
        return GradleUtil.toStringList(this._readOnlyPrefixes);
    }

    @Input
    public List<String> getResourceActionsConfigs() {
        return GradleUtil.toStringList(this._resourceActionsConfigs);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getResourcesDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._resourcesDir);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSpringFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._springFile);
    }

    @Input
    public List<String> getSpringNamespaces() {
        return GradleUtil.toStringList(this._springNamespaces);
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSqlDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sqlDir);
    }

    @Input
    public String getSqlFileName() {
        return GradleUtil.toString((Object)this._sqlFileName);
    }

    @Input
    public String getSqlIndexesFileName() {
        return GradleUtil.toString((Object)this._sqlIndexesFileName);
    }

    @Input
    public String getSqlSequencesFileName() {
        return GradleUtil.toString((Object)this._sqlSequencesFileName);
    }

    @Input
    @Optional
    public String getTargetEntityName() {
        return GradleUtil.toString((Object)this._targetEntityName);
    }

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getTestDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._testDir);
    }

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getUADDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._uadDir);
    }

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getUADTestIntegrationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._uadTestIntegrationDir);
    }

    public BuildServiceTask incubationFeatures(Iterable<String> incubationFeatures) {
        GUtil.addToCollection(this._incubationFeatures, incubationFeatures);
        return this;
    }

    public BuildServiceTask incubationFeatures(String ... incubationFeatures) {
        return this.incubationFeatures(Arrays.asList(incubationFeatures));
    }

    @Input
    public boolean isAutoImportDefaultReferences() {
        return this._autoImportDefaultReferences;
    }

    @Input
    public boolean isAutoNamespaceTables() {
        return this._autoNamespaceTables;
    }

    @Input
    public boolean isBuildNumberIncrement() {
        return this._buildNumberIncrement;
    }

    @Input
    public boolean isOsgiModule() {
        return this._osgiModule;
    }

    public BuildServiceTask modelHintsConfigs(Iterable<Object> modelHintsConfigs) {
        GUtil.addToCollection(this._modelHintsConfigs, modelHintsConfigs);
        return this;
    }

    public BuildServiceTask modelHintsConfigs(Object ... modelHintsConfigs) {
        return this.modelHintsConfigs(Arrays.asList(modelHintsConfigs));
    }

    public BuildServiceTask readOnlyPrefixes(Iterable<Object> readOnlyPrefixes) {
        GUtil.addToCollection(this._readOnlyPrefixes, readOnlyPrefixes);
        return this;
    }

    public BuildServiceTask readOnlyPrefixes(Object ... readOnlyPrefixes) {
        return this.readOnlyPrefixes(Arrays.asList(readOnlyPrefixes));
    }

    public BuildServiceTask resourceActionsConfigs(Iterable<Object> resourceActionsConfigs) {
        GUtil.addToCollection(this._resourceActionsConfigs, resourceActionsConfigs);
        return this;
    }

    public BuildServiceTask resourceActionsConfigs(Object ... resourceActionsConfigs) {
        return this.resourceActionsConfigs(Arrays.asList(resourceActionsConfigs));
    }

    public void setApiDir(Object apiDir) {
        this._apiDir = apiDir;
    }

    public void setAutoImportDefaultReferences(boolean autoImportDefaultReferences) {
        this._autoImportDefaultReferences = autoImportDefaultReferences;
    }

    public void setAutoNamespaceTables(boolean autoNamespaceTables) {
        this._autoNamespaceTables = autoNamespaceTables;
    }

    public void setBeanLocatorUtil(Object beanLocatorUtil) {
        this._beanLocatorUtil = beanLocatorUtil;
    }

    public void setBuildNumber(long buildNumber) {
        this._buildNumber = buildNumber;
    }

    public void setBuildNumberIncrement(boolean buildNumberIncrement) {
        this._buildNumberIncrement = buildNumberIncrement;
    }

    public void setDatabaseNameMaxLength(int databaseNameMaxLength) {
        this._databaseNameMaxLength = databaseNameMaxLength;
    }

    public void setHbmFile(Object hbmFile) {
        this._hbmFile = hbmFile;
    }

    public void setImplDir(Object implDir) {
        this._implDir = implDir;
    }

    public void setIncubationFeatures(Iterable<String> incubationFeatures) {
        this._incubationFeatures.clear();
        this.incubationFeatures(incubationFeatures);
    }

    public void setIncubationFeatures(String ... incubationFeatures) {
        this.setIncubationFeatures(Arrays.asList(incubationFeatures));
    }

    public void setInputFile(Object inputFile) {
        this._inputFile = inputFile;
    }

    public void setModelHintsConfigs(Iterable<Object> modelHintsConfigs) {
        this._modelHintsConfigs.clear();
        this.modelHintsConfigs(modelHintsConfigs);
    }

    public void setModelHintsConfigs(Object ... modelHintsConfigs) {
        this.setModelHintsConfigs(Arrays.asList(modelHintsConfigs));
    }

    public void setModelHintsFile(Object modelHintsFile) {
        this._modelHintsFile = modelHintsFile;
    }

    public void setOsgiModule(boolean osgiModule) {
        this._osgiModule = osgiModule;
    }

    public void setPluginName(Object pluginName) {
        this._pluginName = pluginName;
    }

    public void setPropsUtil(Object propsUtil) {
        this._propsUtil = propsUtil;
    }

    public void setReadOnlyPrefixes(Iterable<Object> readOnlyPrefixes) {
        this._readOnlyPrefixes.clear();
        this.readOnlyPrefixes(readOnlyPrefixes);
    }

    public void setReadOnlyPrefixes(Object ... readOnlyPrefixes) {
        this.setReadOnlyPrefixes(Arrays.asList(readOnlyPrefixes));
    }

    public void setResourceActionsConfigs(Iterable<Object> resourceActionsConfigs) {
        this._resourceActionsConfigs.clear();
        this.resourceActionsConfigs(resourceActionsConfigs);
    }

    public void setResourceActionsConfigs(Object ... resourceActionsConfigs) {
        this.setResourceActionsConfigs(Arrays.asList(resourceActionsConfigs));
    }

    public void setResourcesDir(Object resourcesDir) {
        this._resourcesDir = resourcesDir;
    }

    public void setSpringFile(Object springFile) {
        this._springFile = springFile;
    }

    public void setSpringNamespaces(Iterable<Object> springNamespaces) {
        this._springNamespaces.clear();
        this.springNamespaces(springNamespaces);
    }

    public void setSpringNamespaces(Object ... springNamespaces) {
        this.setSpringNamespaces(Arrays.asList(springNamespaces));
    }

    public void setSqlDir(Object sqlDir) {
        this._sqlDir = sqlDir;
    }

    public void setSqlFileName(Object sqlFileName) {
        this._sqlFileName = sqlFileName;
    }

    public void setSqlIndexesFileName(Object sqlIndexesFileName) {
        this._sqlIndexesFileName = sqlIndexesFileName;
    }

    public void setSqlSequencesFileName(Object sqlSequencesFileName) {
        this._sqlSequencesFileName = sqlSequencesFileName;
    }

    public void setTargetEntityName(Object targetEntityName) {
        this._targetEntityName = targetEntityName;
    }

    public void setTestDir(Object testDir) {
        this._testDir = testDir;
    }

    public void setUADDir(Object uadDir) {
        this._uadDir = uadDir;
    }

    public void setUADTestIntegrationDir(Object uadTestIntegrationDir) {
        this._uadTestIntegrationDir = uadTestIntegrationDir;
    }

    public BuildServiceTask springNamespaces(Iterable<Object> springNamespaces) {
        GUtil.addToCollection(this._springNamespaces, springNamespaces);
        return this;
    }

    public BuildServiceTask springNamespaces(Object ... springNamespaces) {
        return this.springNamespaces(Arrays.asList(springNamespaces));
    }

    protected List<String> getCompleteArgs() {
        File uadTestIntegrationDir;
        File uadDir;
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("service.api.dir=" + this._relativize(this.getApiDir()));
        args.add("service.auto.import.default.references=" + this._autoImportDefaultReferences);
        args.add("service.auto.namespace.tables=" + this._autoNamespaceTables);
        args.add("service.bean.locator.util=" + this.getBeanLocatorUtil());
        args.add("service.build.number.increment=" + this._buildNumberIncrement);
        args.add("service.build.number=" + this._buildNumber);
        args.add("service.database.name.max.length=" + this._databaseNameMaxLength);
        args.add("service.hbm.file=" + this._relativize(this.getHbmFile()));
        args.add("service.impl.dir=" + this._relativize(this.getImplDir()));
        args.add("service.incubation.features=" + CollectionUtils.join((String)",", this._incubationFeatures));
        args.add("service.input.file=" + this._relativize(this.getInputFile()));
        args.add("service.model.hints.configs=" + CollectionUtils.join((String)",", this.getCompleteModelHintsConfigs()));
        args.add("service.model.hints.file=" + this._relativize(this.getModelHintsFile()));
        args.add("service.osgi.module=" + this._osgiModule);
        args.add("service.plugin.name=" + this.getPluginName());
        args.add("service.props.util=" + this.getPropsUtil());
        args.add("service.read.only.prefixes=" + CollectionUtils.join((String)",", this.getReadOnlyPrefixes()));
        args.add("service.resource.actions.configs=" + CollectionUtils.join((String)",", this.getResourceActionsConfigs()));
        args.add("service.resources.dir=" + this._relativize(this.getResourcesDir()));
        args.add("service.spring.file=" + this._relativize(this.getSpringFile()));
        args.add("service.spring.namespaces=" + CollectionUtils.join((String)",", this.getSpringNamespaces()));
        args.add("service.sql.dir=" + this._relativize(this.getSqlDir()));
        args.add("service.sql.file=" + this.getSqlFileName());
        args.add("service.sql.indexes.file=" + this.getSqlIndexesFileName());
        args.add("service.sql.sequences.file=" + this.getSqlSequencesFileName());
        String targetEntityName = this.getTargetEntityName();
        if (Validator.isNull((String)targetEntityName)) {
            targetEntityName = "${service.target.entity.name}";
        }
        args.add("service.target.entity.name=" + targetEntityName);
        File testDir = this.getTestDir();
        if (testDir != null) {
            args.add("service.test.dir=" + this._relativize(testDir));
        }
        if ((uadDir = this.getUADDir()) != null) {
            args.add("service.uad.dir=" + this._relativize(uadDir));
        }
        if ((uadTestIntegrationDir = this.getUADTestIntegrationDir()) != null) {
            args.add("service.uad.test.integration.dir=" + this._relativize(uadTestIntegrationDir));
        }
        return args;
    }

    protected List<String> getCompleteModelHintsConfigs() {
        List<String> modelHintsConfigs = this.getModelHintsConfigs();
        File modelHintsFile = this.getModelHintsFile();
        Project project = this.getProject();
        boolean found = false;
        for (String config : modelHintsConfigs) {
            File configFile;
            if (config.startsWith("classpath*:") || !(configFile = project.file((Object)config)).equals(modelHintsFile)) continue;
            found = true;
            break;
        }
        if (!found) {
            modelHintsConfigs.add(this._relativize(modelHintsFile));
        }
        return modelHintsConfigs;
    }

    private String _relativize(File file) {
        String relativePath = FileUtil.relativize((File)file, (File)this.getWorkingDir());
        return relativePath.replace('\\', '/');
    }
}

