/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.rest.builder;

import com.liferay.gradle.plugins.rest.builder.BuildRESTTask;
import com.liferay.gradle.plugins.rest.builder.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.service.ServiceRegistry;

public class RESTBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_REST_TASK_NAME = "buildREST";
    public static final String CONFIGURATION_NAME = "restBuilder";
    private static final Pattern _apiDirPattern = Pattern.compile("^apiDir:\\s*\"(.+)\"", 8);

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration restBuilderConfiguration = this._addConfigurationRESTBuilder(project);
        final BuildRESTTask buildRESTTask = this._addTaskBuildREST(project);
        this._configureTasksBuildREST(project, restBuilderConfiguration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                RESTBuilderPlugin.this._configureTaskBuildREST(buildRESTTask);
            }
        });
    }

    private Configuration _addConfigurationRESTBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                RESTBuilderPlugin.this._addDependenciesRESTBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay REST Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesRESTBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.rest.builder", (String)"latest.release");
    }

    private BuildRESTTask _addTaskBuildREST(Project project) {
        BuildRESTTask buildRESTTask = (BuildRESTTask)GradleUtil.addTask((Project)project, (String)BUILD_REST_TASK_NAME, BuildRESTTask.class);
        buildRESTTask.setDescription("Runs Liferay REST Builder.");
        buildRESTTask.setGroup("build");
        buildRESTTask.setRESTConfigDir(project.getProjectDir());
        return buildRESTTask;
    }

    private void _configureTaskBuildREST(final BuildRESTTask buildRESTTask) {
        Project project = buildRESTTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId("com.liferay.defaults.plugin", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                RESTBuilderPlugin.this._configureTaskBuildRESTForLiferayDefaultsPlugin(buildRESTTask);
            }
        });
    }

    private void _configureTaskBuildRESTClasspath(BuildRESTTask buildRESTTask, Configuration restBuilderConfiguration) {
        buildRESTTask.setClasspath((FileCollection)restBuilderConfiguration);
    }

    private void _configureTaskBuildRESTForLiferayDefaultsPlugin(BuildRESTTask buildRESTTask) {
        String content;
        Project project;
        block10: {
            File restConfigDir = buildRESTTask.getRESTConfigDir();
            if (restConfigDir == null || !restConfigDir.exists()) {
                return;
            }
            File restConfigYAMLFile = new File(restConfigDir, "rest-config.yaml");
            if (!restConfigYAMLFile.exists()) {
                return;
            }
            project = buildRESTTask.getProject();
            content = null;
            try {
                content = new String(Files.readAllBytes(restConfigYAMLFile.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                Logger logger = project.getLogger();
                if (!logger.isWarnEnabled()) break block10;
                logger.warn("Unable to read {}", (Object)restConfigYAMLFile);
            }
        }
        if (Validator.isNull((String)content)) {
            return;
        }
        Matcher matcher = _apiDirPattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        File apiProjectDir = GradleUtil.getRootDir((File)project.file((Object)matcher.group(1)), (String)"bnd.bnd");
        if (apiProjectDir == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        String relativePath = FileUtil.relativize((File)apiProjectDir, (File)rootProject.getProjectDir());
        relativePath = relativePath.replace(File.separatorChar, '/');
        String apiProjectPath = ':' + relativePath.replace('/', ':');
        Project apiProject = rootProject.findProject(apiProjectPath);
        if (apiProject == null) {
            String apiProjectName = apiProjectDir.getName();
            apiProject = GradleUtil.findProject(rootProject, apiProjectName);
        }
        if (apiProject == null) {
            return;
        }
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        projectConfigurer.configure((ProjectInternal)apiProject);
        TaskContainer taskContainer = apiProject.getTasks();
        Task task = (Task)taskContainer.findByName("baseline");
        if (task != null) {
            task.setProperty("ignoreFailures", (Object)Boolean.TRUE);
            buildRESTTask.finalizedBy(new Object[]{task});
        }
    }

    private void _configureTasksBuildREST(Project project, final Configuration restBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildRESTTask.class, (Action)new Action<BuildRESTTask>(){

            public void execute(BuildRESTTask buildRESTTask) {
                RESTBuilderPlugin.this._configureTaskBuildRESTClasspath(buildRESTTask, restBuilderConfiguration);
            }
        });
    }
}

