/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner;

import com.liferay.gradle.plugins.poshi.runner.internal.util.GitRepositoryBuildAdapter;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.BuildListener;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;

public class PoshiRunnerResourcesExtension {
    private static final GitRepositoryBuildAdapter _gitRepositoryBuildAdapter = new GitRepositoryBuildAdapter();
    private Object _artifactAppendix;
    private Object _artifactVersion;
    private Object _baseName = "default";
    private final Set<Object> _dirs = new HashSet<Object>();
    private final Project _project;
    private Object _rootDirName;
    private Object _version = "1.0.14";

    public PoshiRunnerResourcesExtension(final Project project) {
        this._project = project;
        Gradle gradle = project.getGradle();
        gradle.addBuildListener((BuildListener)_gitRepositoryBuildAdapter);
        this._artifactAppendix = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _gitRepositoryBuildAdapter.getBranchName(project);
            }
        };
        this._artifactVersion = new Callable<String>(){

            @Override
            public String call() throws Exception {
                Date date = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
                return dateFormat.format(date) + "-" + _gitRepositoryBuildAdapter.getHeadHash(project);
            }
        };
    }

    public PoshiRunnerResourcesExtension dirs(Iterable<?> dirs) {
        GUtil.addToCollection(this._dirs, dirs);
        return this;
    }

    public String getArtifactAppendix() {
        return GradleUtil.toString((Object)this._artifactAppendix);
    }

    public String getArtifactVersion() {
        return GradleUtil.toString((Object)this._artifactVersion);
    }

    public String getBaseName() {
        return GradleUtil.toString((Object)this._baseName);
    }

    public Iterable<Object> getDirs() {
        return this._dirs;
    }

    public String getRootDirName() {
        return GradleUtil.toString((Object)this._rootDirName);
    }

    public String getVersion() {
        return GradleUtil.toString((Object)this._version);
    }

    public void setArtifactAppendix(Object artifactAppendix) {
        this._artifactAppendix = artifactAppendix;
    }

    public void setArtifactVersion(Object artifactVersion) {
        this._artifactVersion = artifactVersion;
    }

    public void setBaseName(Object baseName) {
        this._baseName = baseName;
    }

    public void setDirs(Iterable<?> dirs) {
        this._dirs.clear();
        this.dirs(dirs);
    }

    public void setRootDirName(Object rootDirName) {
        this._rootDirName = rootDirName;
    }

    public void setVersion(Object version) {
        this._version = version;
    }
}

