/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner;

import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerExtension;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class PoshiRunnerPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_WEB_DRIVER_BROWSER_BINARY_TASK_NAME = "downloadWebDriverBrowserBinary";
    public static final String EVALUATE_POSHI_CONSOLE_TASK_NAME = "evaluatePoshiConsole";
    public static final String EXECUTE_PQL_QUERY_TASK_NAME = "executePQLQuery";
    public static final String EXPAND_POSHI_RUNNER_TASK_NAME = "expandPoshiRunner";
    public static final String POSHI_RUNNER_CONFIGURATION_NAME = "poshiRunner";
    public static final String POSHI_RUNNER_RESOURCES_CONFIGURATION_NAME = "poshiRunnerResources";
    public static final String RUN_POSHI_TASK_NAME = "runPoshi";
    public static final String SIKULI_CONFIGURATION_NAME = "sikuli";
    public static final String VALIDATE_POSHI_TASK_NAME = "validatePoshi";
    public static final String WRITE_POSHI_PROPERTIES_TASK_NAME = "writePoshiProperties";
    private static final String _DEFAULT_CHROME_DRIVER_VERSION = "2.37";
    private static final String _DEFAULT_GECKO_DRIVER_VERSION = "0.31.0";
    private static final String _START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    private static final String _STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";
    private static final Map<String, String> _chromeDriverVersions = new HashMap<String, String>(){
        {
            this.put("86", "86.0.4240.22");
            this.put("87", "87.0.4280.20");
            this.put("88", "88.0.4324.96");
            this.put("89", "89.0.4389.23");
            this.put("90", "90.0.4430.24");
            this.put("91", "91.0.4472.101");
            this.put("92", "92.0.4515.107");
            this.put("93", "93.0.4577.63");
            this.put("94", "94.0.4606.61");
            this.put("95", "95.0.4638.17");
            this.put("96", "96.0.4664.45");
            this.put("97", "97.0.4692.71");
            this.put("98", "98.0.4758.102");
            this.put("99", "99.0.4844.51");
            this.put("100", "100.0.4896.60");
        }
    };
    private static final Pattern _chromeVersionPattern = Pattern.compile("[A-z=\\s]+(?<chromeMajorVersion>[0-9]+)\\.");
    private static final Map<String, String> _webDriverBrowserBinaryNames = new HashMap<String, String>(){
        {
            this.put("chrome", "chromedriver");
            this.put("firefox", "geckodriver");
        }
    };
    private static final Map<String, String> _webDriverBrowserBinaryPropertyNames = new HashMap<String, String>(){
        {
            this.put("chrome", "webdriver.chrome.driver");
            this.put("firefox", "webdriver.gecko.driver");
        }
    };

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        final PoshiRunnerExtension poshiRunnerExtension = (PoshiRunnerExtension)GradleUtil.addExtension((ExtensionAware)project, (String)POSHI_RUNNER_CONFIGURATION_NAME, PoshiRunnerExtension.class);
        this._addConfigurationPoshiRunner(project, poshiRunnerExtension);
        this._addConfigurationSikuli(project, poshiRunnerExtension);
        this._addConfigurationPoshiRunnerResources(project);
        final JavaExec executePQLQueryTask = this._addTaskExecutePQLQuery(project);
        final JavaExec evaluatePoshiConsoleTask = this._addTaskEvaluatePoshiConsole(project);
        this._addTaskExpandPoshiRunner(project);
        final Task downloadWebDriverBrowserBinaryTask = this._addTaskDownloadWebDriverBrowserBinary(project, poshiRunnerExtension);
        final Test runPoshiTask = this._addTaskRunPoshi(project);
        final JavaExec validatePoshiTask = this._addTaskValidatePoshi(project);
        final JavaExec writePoshiPropertiesTask = this._addTaskWritePoshiProperties(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Properties poshiProperties = PoshiRunnerPlugin.this._getPoshiProperties(poshiRunnerExtension);
                PoshiRunnerPlugin.this._configureTaskDownloadWebDriverBrowserBinary(downloadWebDriverBrowserBinaryTask, poshiProperties);
                PoshiRunnerPlugin.this._configureTaskExecutePQLQuery(executePQLQueryTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this._configureTaskEvaluatePoshiConsole(evaluatePoshiConsoleTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this._configureTaskRunPoshi(runPoshiTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this._configureTaskValidatePoshi(validatePoshiTask, poshiProperties, poshiRunnerExtension);
                PoshiRunnerPlugin.this._configureTaskWritePoshiProperties(writePoshiPropertiesTask, poshiProperties, poshiRunnerExtension);
            }
        });
    }

    private Configuration _addConfigurationPoshiRunner(final Project project, final PoshiRunnerExtension poshiRunnerExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                PoshiRunnerPlugin.this._addDependenciesPoshiRunner(project, poshiRunnerExtension);
            }
        });
        configuration.setDescription("Configures Poshi Runner for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationPoshiRunnerResources(Project project) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.maybeCreate(POSHI_RUNNER_RESOURCES_CONFIGURATION_NAME);
        configuration.setDescription("Configures the Poshi Runner resources for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationSikuli(final Project project, final PoshiRunnerExtension poshiRunnerExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)SIKULI_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                PoshiRunnerPlugin.this._addDependenciesSikuli(project, poshiRunnerExtension);
            }
        });
        configuration.setDescription("Configures Sikuli for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesPoshiRunner(Project project, PoshiRunnerExtension poshiRunnerExtension) {
        GradleUtil.addDependency((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.poshi.runner", (String)poshiRunnerExtension.getVersion());
    }

    private void _addDependenciesSikuli(Project project, PoshiRunnerExtension poshiRunnerExtension) {
        String bitMode = OSDetector.getBitmode();
        bitMode = bitMode.equals("32") ? "x86" : "x86_64";
        String os = "linux";
        if (OSDetector.isApple()) {
            os = "macosx";
        } else if (OSDetector.isWindows()) {
            os = "windows";
        }
        String classifier = os + "-" + bitMode;
        GradleUtil.addDependency((Project)project, (String)SIKULI_CONFIGURATION_NAME, (String)"org.bytedeco.javacpp-presets", (String)"opencv", (String)poshiRunnerExtension.getOpenCVVersion(), (String)classifier, (boolean)true);
    }

    private Task _addTaskDownloadWebDriverBrowserBinary(final Project project, final PoshiRunnerExtension poshiRunnerExtension) {
        Task task = GradleUtil.addTask((Project)project, (String)DOWNLOAD_WEB_DRIVER_BROWSER_BINARY_TASK_NAME, Task.class);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                final File webDriverDir = PoshiRunnerPlugin.this._getWebDriverDir(project);
                project.delete(new Object[]{webDriverDir});
                project.copy((Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        File file = PoshiRunnerPlugin.this._getWebDriverBrowserBinaryFile(project, PoshiRunnerPlugin.this._getPoshiProperties(poshiRunnerExtension));
                        String fileName = file.getName();
                        if (fileName.endsWith(".zip")) {
                            copySpec.from(new Object[]{project.zipTree((Object)file)});
                        } else {
                            copySpec.from(new Object[]{project.tarTree((Object)file)});
                        }
                        copySpec.into((Object)webDriverDir);
                    }
                });
            }
        });
        return task;
    }

    private JavaExec _addTaskEvaluatePoshiConsole(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)EVALUATE_POSHI_CONSOLE_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this._getPoshiRunnerClasspath(project));
        javaExec.setDescription("Evaluate the console output errors.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.runner.PoshiRunnerConsoleEvaluator");
        return javaExec;
    }

    private JavaExec _addTaskExecutePQLQuery(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)EXECUTE_PQL_QUERY_TASK_NAME, JavaExec.class);
        javaExec.args(Collections.singleton(EXECUTE_PQL_QUERY_TASK_NAME));
        javaExec.setClasspath(this._getPoshiRunnerClasspath(project));
        javaExec.setDescription("Execute the PQL query.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.runner.PoshiRunnerCommandExecutor");
        return javaExec;
    }

    private Copy _addTaskExpandPoshiRunner(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_POSHI_RUNNER_TASK_NAME, Copy.class);
        Closure<Void> closure = new Closure<Void>((Object)project){

            public FileTree doCall() {
                Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)PoshiRunnerPlugin.POSHI_RUNNER_CONFIGURATION_NAME);
                for (File file : configuration) {
                    String fileName = file.getName();
                    if (!fileName.startsWith("com.liferay.poshi.runner-")) continue;
                    return project.zipTree((Object)file);
                }
                return null;
            }
        };
        copy.from(new Object[]{closure});
        copy.into((Object)this._getExpandedPoshiRunnerDir(project));
        return copy;
    }

    private Test _addTaskRunPoshi(Project project) {
        final Test test = (Test)GradleUtil.addTask((Project)project, (String)RUN_POSHI_TASK_NAME, Test.class);
        test.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)RUN_POSHI_TASK_NAME), DOWNLOAD_WEB_DRIVER_BROWSER_BINARY_TASK_NAME, EXPAND_POSHI_RUNNER_TASK_NAME});
        test.include(new String[]{"com/liferay/poshi/runner/PoshiRunner.class"});
        test.setClasspath(this._getPoshiRunnerClasspath(project));
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.toString());
        test.setDescription("Execute tests using Poshi Runner.");
        test.setGroup("verification");
        test.setScanForTestClasses(false);
        test.setTestClassesDirs((FileCollection)project.files(new Object[]{this._getExpandedPoshiRunnerDir(project)}));
        TaskOutputsInternal taskOutputs = test.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setShowStandardStreams(true);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId("com.liferay.test.integration", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                test.dependsOn(new Object[]{PoshiRunnerPlugin._START_TESTABLE_TOMCAT_TASK_NAME});
                Task task = GradleUtil.getTask((Project)test.getProject(), (String)PoshiRunnerPlugin._STOP_TESTABLE_TOMCAT_TASK_NAME);
                task.mustRunAfter(new Object[]{test});
            }
        });
        return test;
    }

    private JavaExec _addTaskValidatePoshi(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)VALIDATE_POSHI_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this._getPoshiRunnerClasspath(project));
        javaExec.setDescription("Validates the Poshi files syntax.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.core.PoshiValidation");
        return javaExec;
    }

    private JavaExec _addTaskWritePoshiProperties(Project project) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)WRITE_POSHI_PROPERTIES_TASK_NAME, JavaExec.class);
        javaExec.setClasspath(this._getPoshiRunnerClasspath(project));
        javaExec.setDescription("Write the Poshi properties files.");
        javaExec.setGroup("verification");
        javaExec.setMain("com.liferay.poshi.core.PoshiContext");
        return javaExec;
    }

    private void _configureTaskDownloadWebDriverBrowserBinary(Task task, final Properties poshiProperties) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return PoshiRunnerPlugin.this._isDownloadWebDriverBrowserBinary(poshiProperties);
            }
        });
    }

    private void _configureTaskEvaluatePoshiConsole(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this._populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, javaExec.getProject(), poshiRunnerExtension);
    }

    private void _configureTaskExecutePQLQuery(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this._populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, javaExec.getProject(), poshiRunnerExtension);
    }

    private void _configureTaskRunPoshi(Test test, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this._configureTaskRunPoshiBinResultsDir(test);
        this._configureTaskRunPoshiReports(test);
        this._populateSystemProperties(test.getSystemProperties(), poshiProperties, test.getProject(), poshiRunnerExtension);
        this._populateWebDriverSystemProperties(test, poshiProperties);
    }

    private void _configureTaskRunPoshiBinResultsDir(Test test) {
        if (test.getBinResultsDir() != null) {
            return;
        }
        Project project = test.getProject();
        test.setBinResultsDir(project.file((Object)"test-results/binary/runPoshi"));
    }

    private void _configureTaskRunPoshiReports(Test test) {
        Project project = test.getProject();
        TestTaskReports testTaskReports = test.getReports();
        DirectoryReport directoryReport = testTaskReports.getHtml();
        if (directoryReport.getDestination() == null) {
            directoryReport.setDestination(project.file((Object)"tests"));
        }
        if ((directoryReport = testTaskReports.getJunitXml()).getDestination() == null) {
            directoryReport.setDestination(project.file((Object)"test-results"));
        }
    }

    private void _configureTaskValidatePoshi(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this._populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, javaExec.getProject(), poshiRunnerExtension);
    }

    private void _configureTaskWritePoshiProperties(JavaExec javaExec, Properties poshiProperties, PoshiRunnerExtension poshiRunnerExtension) {
        this._populateSystemProperties(javaExec.getSystemProperties(), poshiProperties, javaExec.getProject(), poshiRunnerExtension);
    }

    private String _getBrowserType(Properties poshiProperties) {
        String browserType = poshiProperties.getProperty("browser.type");
        if (Validator.isNull((String)browserType)) {
            return "chrome";
        }
        return browserType;
    }

    private String _getChromeDriverURL(String chromeDriverVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://chromedriver.storage.googleapis.com/");
        sb.append(chromeDriverVersion);
        sb.append("/chromedriver_");
        if (OSDetector.isApple()) {
            sb.append("mac64");
        } else if (OSDetector.isWindows()) {
            sb.append("win32");
        } else {
            sb.append("linux64");
        }
        sb.append(".zip");
        return sb.toString();
    }

    private String _getChromeDriverVersion(Project project, String chromeBinaryPath) {
        String chromeMajorVersion;
        if (chromeBinaryPath == null) {
            chromeBinaryPath = "/usr/bin/google-chrome";
            if (OSDetector.isApple()) {
                chromeBinaryPath = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
            } else if (OSDetector.isWindows()) {
                chromeBinaryPath = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
            }
            File chromeBinaryFile = new File(chromeBinaryPath);
            if (!chromeBinaryFile.exists()) {
                throw new IllegalArgumentException("Unable to not find a Google Chrome binary. Manually set \"browser.chrome.bin.file\" in \"poshi.properties\" to a Google Chrome or Chromium binary.");
            }
        }
        final String finalChromeBinaryPath = chromeBinaryPath;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                if (OSDetector.isWindows()) {
                    execSpec.commandLine(new Object[]{"cmd", "/c", "wmic datafile where name=\"" + finalChromeBinaryPath.replace("\\", "\\\\") + "\" get Version /value"});
                } else {
                    execSpec.commandLine(new Object[]{finalChromeBinaryPath, "--version"});
                }
                execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
            }
        });
        String chromeVersionOutput = byteArrayOutputStream.toString();
        Matcher matcher = _chromeVersionPattern.matcher(chromeVersionOutput);
        if (matcher.find() && _chromeDriverVersions.containsKey(chromeMajorVersion = matcher.group("chromeMajorVersion"))) {
            return _chromeDriverVersions.get(chromeMajorVersion);
        }
        return _DEFAULT_CHROME_DRIVER_VERSION;
    }

    private File _getExpandedPoshiRunnerDir(Project project) {
        return new File(project.getBuildDir(), "poshi-runner");
    }

    private String _getGeckoDriverURL(String geckoDriverVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/mozilla/geckodriver/releases/download/v");
        sb.append(geckoDriverVersion);
        sb.append("/geckodriver-v");
        sb.append(geckoDriverVersion);
        sb.append("-");
        if (OSDetector.isApple()) {
            sb.append("macos.tar.gz");
        } else if (OSDetector.isWindows()) {
            sb.append("win32.zip");
        } else {
            sb.append("linux64.tar.gz");
        }
        return sb.toString();
    }

    private File _getPoshiExtPropertiesFile(File poshiPropertiesFile) {
        String fileName = poshiPropertiesFile.getName();
        int pos = fileName.lastIndexOf(46);
        if (pos <= 0) {
            return new File(poshiPropertiesFile.getParentFile(), fileName + "-ext");
        }
        String extension = fileName.substring(pos + 1);
        String shortFileName = fileName.substring(0, fileName.length() - extension.length() - 1);
        return new File(poshiPropertiesFile.getParentFile(), shortFileName + "-ext." + extension);
    }

    private Properties _getPoshiProperties(PoshiRunnerExtension poshiRunnerExtension) {
        Properties poshiProperties = new Properties();
        File poshiPropertiesFile = poshiRunnerExtension.getPoshiPropertiesFile();
        if (poshiPropertiesFile != null) {
            File poshiExtPropertiesFile;
            if (poshiPropertiesFile.exists()) {
                poshiProperties.putAll((Map<?, ?>)GUtil.loadProperties((File)poshiPropertiesFile));
            }
            if ((poshiExtPropertiesFile = this._getPoshiExtPropertiesFile(poshiPropertiesFile)).exists()) {
                poshiProperties.putAll((Map<?, ?>)GUtil.loadProperties((File)poshiExtPropertiesFile));
            }
        }
        return poshiProperties;
    }

    private FileCollection _getPoshiRunnerClasspath(Project project) {
        Configuration poshiRunnerConfiguration = GradleUtil.getConfiguration((Project)project, (String)POSHI_RUNNER_CONFIGURATION_NAME);
        Configuration poshiRunnerResourcesConfiguration = GradleUtil.getConfiguration((Project)project, (String)POSHI_RUNNER_RESOURCES_CONFIGURATION_NAME);
        Configuration sikuliConfiguration = GradleUtil.getConfiguration((Project)project, (String)SIKULI_CONFIGURATION_NAME);
        return project.files(new Object[]{poshiRunnerConfiguration, poshiRunnerResourcesConfiguration, sikuliConfiguration});
    }

    private File _getWebDriverBrowserBinaryFile(Project project, Properties poshiProperties) {
        String url = null;
        String browserType = this._getBrowserType(poshiProperties);
        if (browserType.equals("chrome")) {
            String chromeBinaryPath = poshiProperties.getProperty("browser.chrome.bin.file");
            url = this._getChromeDriverURL(this._getChromeDriverVersion(project, chromeBinaryPath));
        }
        if (browserType.equals("firefox")) {
            url = this._getGeckoDriverURL(_DEFAULT_GECKO_DRIVER_VERSION);
        }
        if (Validator.isNull(url)) {
            throw new RuntimeException("Unable to get browser driver URL");
        }
        try {
            return FileUtil.get((Project)project, (String)url, null);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
    }

    private String _getWebDriverBrowserBinaryName(Properties poshiProperties) {
        return _webDriverBrowserBinaryNames.get(this._getBrowserType(poshiProperties));
    }

    private String _getWebDriverBrowserBinaryPropertyName(Properties poshiProperties) {
        return _webDriverBrowserBinaryPropertyNames.get(this._getBrowserType(poshiProperties));
    }

    private File _getWebDriverDir(Project project) {
        return new File(project.getBuildDir(), "webdriver");
    }

    private boolean _isDownloadWebDriverBrowserBinary(Properties poshiProperties) {
        String webDriverBrowserBinaryPropertyName = this._getWebDriverBrowserBinaryPropertyName(poshiProperties);
        if (poshiProperties.containsKey(webDriverBrowserBinaryPropertyName)) {
            return false;
        }
        return Validator.isNull((String)System.getProperty(webDriverBrowserBinaryPropertyName));
    }

    private void _populateSystemProperties(Map<String, Object> systemProperties, Properties poshiProperties, Project project, PoshiRunnerExtension poshiRunnerExtension) {
        List<String> testNames;
        systemProperties.putAll(poshiRunnerExtension.getPoshiProperties());
        File baseDir = poshiRunnerExtension.getBaseDir();
        if (baseDir != null && baseDir.exists()) {
            systemProperties.put("test.base.dir.name", project.relativePath((Object)baseDir));
        }
        if (!(testNames = poshiRunnerExtension.getTestNames()).isEmpty()) {
            systemProperties.put("test.name", CollectionUtils.join((String)",", testNames));
        }
        ExtensionContainer extensionContainer = project.getExtensions();
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        Map properties = extraPropertiesExtension.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String propertyName = (String)entry.getKey();
            String[] array = propertyName.split("(?=\\p{Upper})");
            if (!Objects.equals(array[0], "poshi") || array.length <= 1) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < array.length; ++i) {
                sb.append(array[i].toLowerCase());
                sb.append('.');
            }
            sb.setLength(sb.length() - 1);
            systemProperties.put(sb.toString(), entry.getValue());
        }
        if (poshiProperties != null) {
            Enumeration<?> enumeration = poshiProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = poshiProperties.getProperty(key);
                systemProperties.put(key, value);
            }
        }
    }

    private void _populateWebDriverSystemProperties(Test test, Properties poshiProperties) {
        String webDriverBrowserBinaryPropertyName = this._getWebDriverBrowserBinaryPropertyName(poshiProperties);
        if (poshiProperties.containsKey(webDriverBrowserBinaryPropertyName)) {
            return;
        }
        String webDriverBrowserBinaryPropertyValue = System.getProperty(webDriverBrowserBinaryPropertyName);
        if (Validator.isNull((String)webDriverBrowserBinaryPropertyValue)) {
            webDriverBrowserBinaryPropertyValue = this._getWebDriverDir(test.getProject()) + "/" + this._getWebDriverBrowserBinaryName(poshiProperties);
            if (OSDetector.isWindows()) {
                webDriverBrowserBinaryPropertyValue = webDriverBrowserBinaryPropertyValue + ".exe";
            }
        }
        if (Validator.isNotNull((String)webDriverBrowserBinaryPropertyValue)) {
            Map systemProperties = test.getSystemProperties();
            systemProperties.put(webDriverBrowserBinaryPropertyName, webDriverBrowserBinaryPropertyValue);
        }
    }
}

