/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecSpec;

public class GitRepositoryBuildAdapter
extends BuildAdapter {
    private static final Logger _logger = Logging.getLogger(GitRepositoryBuildAdapter.class);
    private final Map<File, GitRepositoryBag> _gitRepositoryBags = new HashMap<File, GitRepositoryBag>();

    public void buildFinished(BuildResult buildResult) {
        this._gitRepositoryBags.clear();
    }

    public String getBranchName(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.branchName;
    }

    public String getHeadHash(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.hashHead;
    }

    private synchronized GitRepositoryBag _getGitRepositoryBag(Project project) {
        File rootDir = project.getRootDir();
        GitRepositoryBag gitRepositoryBag = this._gitRepositoryBags.get(rootDir);
        if (gitRepositoryBag != null) {
            return gitRepositoryBag;
        }
        long start = System.currentTimeMillis();
        gitRepositoryBag = new GitRepositoryBag(this._getGitResult(project, "rev-parse", "--abbrev-ref", "HEAD"), this._getGitResult(project, "rev-parse", "--short", "HEAD"));
        this._gitRepositoryBags.put(rootDir, gitRepositoryBag);
        if (_logger.isInfoEnabled()) {
            _logger.info("Getting data from Git repository in \"{}\" took {} ms.", (Object)rootDir, (Object)(System.currentTimeMillis() - start));
        }
        return gitRepositoryBag;
    }

    private String _getGitResult(Project project, final Object ... args) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.args(args);
                execSpec.setExecutable("git");
                execSpec.setIgnoreExitValue(true);
                execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
            }
        });
        String result = byteArrayOutputStream.toString();
        return result.trim();
    }

    private static class GitRepositoryBag {
        public final String branchName;
        public final String hashHead;

        public GitRepositoryBag(String branchName, String hashHead) {
            this.branchName = branchName;
            this.hashHead = hashHead;
        }
    }
}

