/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner;

import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesExtension;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.Jar;

public class PoshiRunnerResourcesPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "poshiRunnerResources";
    public static final String POSHI_RUNNER_RESOURCES_CONFIGURATION_NAME = "poshiRunnerResources";
    public static final String UPLOAD_POSHI_RUNNER_RESOURCES_TASK_NAME = "uploadPoshiRunnerResources";

    public void apply(Project project) {
        final PoshiRunnerResourcesExtension poshiRunnerResourcesExtension = (PoshiRunnerResourcesExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"poshiRunnerResources", PoshiRunnerResourcesExtension.class);
        Configuration configuration = this._addConfigurationPoshiRunnerResources(project);
        this._addTaskUploadPoshiRunnerResources(project, configuration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                PoshiRunnerResourcesPlugin.this._addArtifactsPoshiRunnerResources(project, poshiRunnerResourcesExtension);
            }
        });
    }

    private Jar _addArtifactPoshiRunnerResources(Project project, final File dir, String baseName, String appendix, String rootDirName, String version) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)("jarPoshiRunnerResources" + StringUtil.capitalize((String)baseName)), Jar.class);
        if (Validator.isNotNull((String)rootDirName)) {
            jar.into((Object)rootDirName, (Closure)new Closure<Void>((Object)jar){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{dir});
                }
            });
        } else {
            jar.from(new Object[]{dir});
        }
        jar.setAppendix(appendix);
        jar.setBaseName(baseName);
        jar.setDescription("Assembles a jar archive containing the Poshi Runner resources in '" + project.relativePath((Object)dir) + "'.");
        jar.setVersion(version);
        ArtifactHandler artifactHandler = project.getArtifacts();
        artifactHandler.add("poshiRunnerResources", (Object)jar);
        return jar;
    }

    private void _addArtifactsPoshiRunnerResources(Project project, PoshiRunnerResourcesExtension poshiRunnerResourcesExtension) {
        String appendix = poshiRunnerResourcesExtension.getArtifactAppendix();
        String rootDirName = poshiRunnerResourcesExtension.getRootDirName();
        String version = poshiRunnerResourcesExtension.getArtifactVersion();
        Map<Object, Object> baseNameDirs = poshiRunnerResourcesExtension.getBaseNameDirs();
        for (Map.Entry<Object, Object> entry : baseNameDirs.entrySet()) {
            String baseName = GradleUtil.toString((Object)entry.getKey());
            File dir = GradleUtil.toFile((Project)project, (Object)entry.getValue());
            this._addArtifactPoshiRunnerResources(project, dir, baseName, appendix, rootDirName, version);
        }
    }

    private Configuration _addConfigurationPoshiRunnerResources(Project project) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.maybeCreate("poshiRunnerResources");
        configuration.setDescription("Configures the Poshi Runner resources artifacts.");
        configuration.setVisible(false);
        return configuration;
    }

    private Upload _addTaskUploadPoshiRunnerResources(Project project, Configuration configuration) {
        Upload upload = (Upload)GradleUtil.addTask((Project)project, (String)UPLOAD_POSHI_RUNNER_RESOURCES_TASK_NAME, Upload.class);
        upload.setConfiguration(configuration);
        upload.setDescription("Uploads all Poshi Runner resources artifacts.");
        upload.setGroup("upload");
        return upload;
    }
}

