/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class GitRepositoryBuildAdapter
extends BuildAdapter {
    private static final Logger _logger = Logging.getLogger(GitRepositoryBuildAdapter.class);
    private final Map<File, GitRepositoryBag> _gitRepositoryBags = new HashMap<File, GitRepositoryBag>();

    public void buildFinished(BuildResult buildResult) {
        this._gitRepositoryBags.clear();
    }

    public String getBranchName(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.branchName;
    }

    public String getHeadHash(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.hashHead;
    }

    private static File _getGitDir(File dir) throws IOException {
        do {
            File gitDir;
            if ((gitDir = RepositoryCache.FileKey.resolve((File)dir, (FS)FS.DETECTED)) == null) continue;
            return gitDir;
        } while ((dir = dir.getParentFile()) != null);
        throw new IOException("Unable to locate .git directory");
    }

    private static String _getHashHead(Repository repository) throws IOException {
        ObjectId objectId = repository.resolve("HEAD");
        ObjectDatabase objectDatabase = repository.getObjectDatabase();
        try (ObjectReader objectReader = objectDatabase.newReader();){
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)objectId);
            String string = abbreviatedObjectId.name();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized GitRepositoryBag _getGitRepositoryBag(Project project) {
        File rootDir = project.getRootDir();
        GitRepositoryBag gitRepositoryBag = this._gitRepositoryBags.get(rootDir);
        if (gitRepositoryBag != null) {
            return gitRepositoryBag;
        }
        long start = System.currentTimeMillis();
        try {
            RepositoryCache.FileKey fileKey = RepositoryCache.FileKey.exact((File)GitRepositoryBuildAdapter._getGitDir(rootDir), (FS)FS.DETECTED);
            try (Repository repository = fileKey.open(true);){
                String branchName = repository.getBranch();
                String hashHead = GitRepositoryBuildAdapter._getHashHead(repository);
                gitRepositoryBag = new GitRepositoryBag(branchName, hashHead);
                this._gitRepositoryBags.put(rootDir, gitRepositoryBag);
                if (_logger.isInfoEnabled()) {
                    _logger.info("Getting data from Git repository in \"{}\" took {} ms.", (Object)repository.getDirectory(), (Object)(System.currentTimeMillis() - start));
                }
                GitRepositoryBag gitRepositoryBag2 = gitRepositoryBag;
                return gitRepositoryBag2;
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private static class GitRepositoryBag {
        public final String branchName;
        public final String hashHead;

        public GitRepositoryBag(String branchName, String hashHead) {
            this.branchName = branchName;
            this.hashHead = hashHead;
        }
    }
}

