/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.Clock;

public class GitRepositoryBuildAdapter
extends BuildAdapter {
    private static final Logger _logger = Logging.getLogger(GitRepositoryBuildAdapter.class);
    private final Map<File, GitRepositoryBag> _gitRepositoryBags = new HashMap<File, GitRepositoryBag>();

    public void buildFinished(BuildResult buildResult) {
        Set<Map.Entry<File, GitRepositoryBag>> entries = this._gitRepositoryBags.entrySet();
        Iterator<Map.Entry<File, GitRepositoryBag>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, GitRepositoryBag> entry = iterator.next();
            GitRepositoryBag gitRepositoryBag = entry.getValue();
            gitRepositoryBag.repository.close();
            iterator.remove();
        }
    }

    public String getBranchName(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.branchName;
    }

    public String getHeadHash(Project project) {
        GitRepositoryBag gitRepositoryBag = this._getGitRepositoryBag(project);
        return gitRepositoryBag.hashHead;
    }

    private static File _getGitDir(File dir) throws IOException {
        do {
            File gitDir;
            if ((gitDir = RepositoryCache.FileKey.resolve((File)dir, (FS)FS.DETECTED)) == null) continue;
            return gitDir;
        } while ((dir = dir.getParentFile()) != null);
        throw new IOException("Unable to locate .git directory");
    }

    private static String _getHashHead(Repository repository) throws IOException {
        ObjectId objectId = repository.resolve("HEAD");
        ObjectDatabase objectDatabase = repository.getObjectDatabase();
        try (ObjectReader objectReader = objectDatabase.newReader();){
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)objectId);
            String string = abbreviatedObjectId.name();
            return string;
        }
    }

    private synchronized GitRepositoryBag _getGitRepositoryBag(Project project) {
        try {
            File rootDir = project.getRootDir();
            GitRepositoryBag gitRepositoryBag = this._gitRepositoryBags.get(rootDir);
            if (gitRepositoryBag == null) {
                Clock clock = new Clock();
                File gitDir = GitRepositoryBuildAdapter._getGitDir(rootDir);
                Repository repository = RepositoryCache.open((RepositoryCache.Key)RepositoryCache.FileKey.exact((File)gitDir, (FS)FS.DETECTED));
                String branchName = repository.getBranch();
                String hashHead = GitRepositoryBuildAdapter._getHashHead(repository);
                gitRepositoryBag = new GitRepositoryBag(repository, branchName, hashHead);
                this._gitRepositoryBags.put(rootDir, gitRepositoryBag);
                if (_logger.isInfoEnabled()) {
                    _logger.info("Getting data from Git repository in \"{}\" took {}.", (Object)gitDir, (Object)clock.getTime());
                }
            }
            return gitRepositoryBag;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private static class GitRepositoryBag {
        public final String branchName;
        public final String hashHead;
        public final Repository repository;

        public GitRepositoryBag(Repository repository, String branchName, String hashHead) {
            this.repository = repository;
            this.branchName = branchName;
            this.hashHead = hashHead;
        }
    }
}

