/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.poshi.runner;

import com.liferay.gradle.plugins.poshi.runner.internal.util.GitRepositoryBuildAdapter;
import com.liferay.gradle.util.GradleUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.BuildListener;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;

public class PoshiRunnerResourcesExtension {
    private static final GitRepositoryBuildAdapter _gitRepositoryBuildAdapter = new GitRepositoryBuildAdapter();
    private Object _artifactAppendix;
    private Object _artifactVersion;
    private final Map<Object, Object> _baseNameDirs = new LinkedHashMap<Object, Object>();
    private final Project _project;
    private Object _rootDirName;

    public PoshiRunnerResourcesExtension(Project project) {
        this._project = project;
        Gradle gradle = this._project.getGradle();
        gradle.addBuildListener((BuildListener)_gitRepositoryBuildAdapter);
        this._artifactAppendix = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _gitRepositoryBuildAdapter.getBranchName(PoshiRunnerResourcesExtension.this._project);
            }
        };
        this._artifactVersion = new Callable<String>(){

            @Override
            public String call() throws Exception {
                Date now = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                return dateFormat.format(now) + "-" + _gitRepositoryBuildAdapter.getHeadHash(PoshiRunnerResourcesExtension.this._project);
            }
        };
    }

    public PoshiRunnerResourcesExtension baseNameDir(Object baseName, Object dir) {
        this._baseNameDirs.put(baseName, dir);
        return this;
    }

    public String getArtifactAppendix() {
        return GradleUtil.toString((Object)this._artifactAppendix);
    }

    public String getArtifactVersion() {
        return GradleUtil.toString((Object)this._artifactVersion);
    }

    public Map<Object, Object> getBaseNameDirs() {
        return this._baseNameDirs;
    }

    public String getRootDirName() {
        return GradleUtil.toString((Object)this._rootDirName);
    }

    public void setArtifactAppendix(Object artifactAppendix) {
        this._artifactAppendix = artifactAppendix;
    }

    public void setArtifactVersion(Object artifactVersion) {
        this._artifactVersion = artifactVersion;
    }

    public void setBaseNameDirs(Map<?, ?> baseNameDirs) {
        this._baseNameDirs.putAll(baseNameDirs);
    }

    public void setRootDirName(Object rootDirName) {
        this._rootDirName = rootDirName;
    }
}

