/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.internal;

import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class NodeExecutor {
    private static final String _NO_PROXY_KEY = "no_proxy";
    private static final String[] _PATH_KEYS = new String[]{"Path", "PATH"};
    private static final Logger _logger = Logging.getLogger(NodeExecutor.class);
    private final List<Object> _args = new ArrayList<Object>();
    private Object _command = "node";
    private final Map<Object, Object> _environment = new LinkedHashMap<Object, Object>();
    private boolean _inheritProxy = true;
    private Object _nodeDir;
    private final Project _project;
    private boolean _useGradleExec;
    private Object _workingDir;

    public NodeExecutor(Project project) {
        this._project = project;
        this._workingDir = this._project.getProjectDir();
    }

    public NodeExecutor args(Iterable<?> args) {
        GUtil.addToCollection(this._args, (Iterable[])new Iterable[]{args});
        return this;
    }

    public NodeExecutor args(Object ... args) {
        return this.args(Arrays.asList(args));
    }

    public NodeExecutor environment(Map<?, ?> environment) {
        this._environment.putAll(environment);
        return this;
    }

    public NodeExecutor environment(Object key, Object value) {
        this._environment.put(key, value);
        return this;
    }

    public String execute() throws Exception {
        File workingDir = this.getWorkingDir();
        workingDir.mkdirs();
        if (this.isUseGradleExec()) {
            return this._executeGradleExec();
        }
        return this._executeProcessBuilder();
    }

    public List<Object> getArgs() {
        return this._args;
    }

    public String getCommand() {
        return GradleUtil.toString((Object)this._command);
    }

    public Map<?, ?> getEnvironment() {
        return this._environment;
    }

    public File getNodeDir() {
        return GradleUtil.toFile(this._project, this._nodeDir);
    }

    public File getWorkingDir() {
        return GradleUtil.toFile(this._project, this._workingDir);
    }

    public boolean isInheritProxy() {
        return this._inheritProxy;
    }

    public boolean isUseGradleExec() {
        return this._useGradleExec;
    }

    public void setArgs(Iterable<?> args) {
        this._args.clear();
        this.args(args);
    }

    public void setArgs(Object ... args) {
        this.setArgs(Arrays.asList(args));
    }

    public void setCommand(Object command) {
        this._command = command;
    }

    public void setEnvironment(Map<?, ?> environment) {
        this._environment.clear();
        this.environment(environment);
    }

    public void setInheritProxy(boolean inheritProxy) {
        this._inheritProxy = inheritProxy;
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setUseGradleExec(boolean useGradleExec) {
        this._useGradleExec = useGradleExec;
    }

    public void setWorkingDir(Object workingDir) {
        this._workingDir = workingDir;
    }

    private String _executeGradleExec() {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.setCommandLine(NodeExecutor.this._getCommandLine());
                execSpec.setEnvironment(NodeExecutor.this._getEnvironment(execSpec.getEnvironment()));
                execSpec.setErrorOutput((OutputStream)new TeeOutputStream(byteArrayOutputStream, System.out));
                execSpec.setStandardOutput((OutputStream)new TeeOutputStream(byteArrayOutputStream, System.out));
                execSpec.setWorkingDir(NodeExecutor.this.getWorkingDir());
            }
        });
        String result = byteArrayOutputStream.toString();
        return result.trim();
    }

    private String _executeProcessBuilder() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(this._getCommandLine());
        processBuilder.directory(this.getWorkingDir());
        processBuilder.redirectErrorStream(true);
        this._updateEnvironment(processBuilder.environment());
        if (_logger.isInfoEnabled()) {
            _logger.info("Running {} from {} with environment variables {}", new Object[]{processBuilder.command(), processBuilder.directory(), processBuilder.environment()});
        }
        Process process = processBuilder.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            System.out.println(line);
            sb.append(line + System.lineSeparator());
        }
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            throw new IOException("Process '" + processBuilder.command() + "' finished with non-zero exit value " + exitValue);
        }
        String result = sb.toString();
        return result.trim();
    }

    private List<String> _getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            commandLine.add("cmd");
            commandLine.addAll(this._getWindowsArgs());
        } else {
            commandLine.add(this._getExecutable());
            commandLine.addAll(GradleUtil.toStringList(this.getArgs()));
        }
        return commandLine;
    }

    private Map<String, String> _getEnvironment(Map<?, ?> environment) {
        HashMap<String, String> newEnvironment = new HashMap<String, String>();
        GUtil.addToMap(newEnvironment, environment);
        this._updateEnvironment(newEnvironment);
        return newEnvironment;
    }

    private String _getExecutable() {
        String executable = GradleUtil.toString((Object)this._command);
        File executableDir = this._getExecutableDir();
        if (executableDir != null) {
            File executableFile = new File(executableDir, executable);
            executable = executableFile.getAbsolutePath();
        }
        return executable;
    }

    private File _getExecutableDir() {
        File nodeDir = this.getNodeDir();
        if (nodeDir == null) {
            return null;
        }
        return NodePluginUtil.getBinDir(nodeDir);
    }

    private List<String> _getWindowsArgs() {
        ArrayList<String> windowsArgs = new ArrayList<String>(2);
        windowsArgs.add("/c");
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        String executable = this._getExecutable();
        if (executable.indexOf(File.separatorChar) == -1) {
            sb.append(executable);
        } else {
            sb.append('\"');
            sb.append(executable);
            sb.append('\"');
        }
        List args = GradleUtil.toStringList(this.getArgs());
        for (String arg : args) {
            sb.append(" \"");
            if (Validator.isNotNull((String)arg)) {
                sb.append(arg);
            }
            sb.append('\"');
        }
        sb.append('\"');
        windowsArgs.add(sb.toString());
        return windowsArgs;
    }

    private void _setNonproxyHosts(Map<String, String> environment) {
        if (environment.containsKey(_NO_PROXY_KEY) || environment.containsKey(_NO_PROXY_KEY.toUpperCase())) {
            if (_logger.isInfoEnabled()) {
                _logger.info("Non-proxy hosts are already set");
            }
            return;
        }
        LinkedHashSet nonProxyHosts = new LinkedHashSet();
        String hosts = System.getProperty("http.nonProxyHosts");
        if (Validator.isNotNull((String)hosts)) {
            Collections.addAll(nonProxyHosts, hosts.split("\\|"));
        }
        if (Validator.isNotNull((String)(hosts = System.getProperty("https.nonProxyHosts")))) {
            Collections.addAll(nonProxyHosts, hosts.split("\\|"));
        }
        if (nonProxyHosts.isEmpty()) {
            return;
        }
        hosts = CollectionUtils.join((String)",", nonProxyHosts);
        environment.put(_NO_PROXY_KEY, hosts);
        if (_logger.isInfoEnabled()) {
            _logger.info("Non-proxy hosts set to {}", (Object)hosts);
        }
    }

    private void _setProxy(Map<String, String> environment, String protocol) {
        String key = protocol + "_proxy";
        if (environment.containsKey(key) || environment.containsKey(key.toUpperCase())) {
            if (_logger.isInfoEnabled()) {
                _logger.info("{} proxy is already set", (Object)protocol.toUpperCase());
            }
            return;
        }
        String host = System.getProperty(protocol + ".proxyHost");
        String port = System.getProperty(protocol + ".proxyPort");
        if (Validator.isNull((String)host) || Validator.isNull((String)port)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(protocol);
        sb.append("://");
        String user = System.getProperty(protocol + ".proxyUser");
        if (Validator.isNotNull((String)user)) {
            sb.append(user);
            String password = System.getProperty(protocol + ".proxyPassword");
            if (Validator.isNotNull((String)password)) {
                sb.append(':');
                sb.append(password);
                sb.append('@');
            }
        }
        sb.append(host);
        sb.append(':');
        sb.append(port);
        String url = sb.toString();
        if (_logger.isInfoEnabled()) {
            _logger.info("{} proxy set to {}", (Object)protocol.toUpperCase(), (Object)url);
        }
        environment.put(key, sb.toString());
    }

    private void _updateEnvironment(Map<String, String> environment) {
        File executableDir;
        GUtil.addToMap(environment, this.getEnvironment());
        if (this.isInheritProxy()) {
            this._setNonproxyHosts(environment);
            this._setProxy(environment, "http");
            this._setProxy(environment, "https");
        }
        if ((executableDir = this._getExecutableDir()) != null) {
            for (String pathKey : _PATH_KEYS) {
                String path = environment.get(pathKey);
                if (Validator.isNull((String)path)) continue;
                path = executableDir.getAbsolutePath() + File.pathSeparator + path;
                environment.put(pathKey, path);
            }
        }
    }

    private static class TeeOutputStream
    extends OutputStream {
        private final OutputStream _outputStream1;
        private final OutputStream _outputStream2;

        public TeeOutputStream(OutputStream outputStream1, OutputStream outputStream2) {
            this._outputStream1 = outputStream1;
            this._outputStream2 = outputStream2;
        }

        @Override
        public void close() throws IOException {
            try {
                this._outputStream1.close();
            }
            finally {
                this._outputStream2.close();
            }
        }

        @Override
        public void flush() throws IOException {
            this._outputStream1.flush();
            this._outputStream2.flush();
        }

        @Override
        public synchronized void write(byte[] bytes) throws IOException {
            this._outputStream1.write(bytes);
            this._outputStream2.write(bytes);
        }

        @Override
        public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
            this._outputStream1.write(bytes, offset, length);
            this._outputStream2.write(bytes, offset, length);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this._outputStream1.write(b);
            this._outputStream2.write(b);
        }
    }
}

