/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class YarnInstallTask
extends ExecutePackageManagerTask {
    private Object _frozenLockFile;

    @Override
    public synchronized void executeNode() throws Exception {
        File yarnrcFile = this._getYarnrcFile();
        if (!yarnrcFile.exists()) {
            this._createYarnrcFile(yarnrcFile);
        }
        super.executeNode();
    }

    public boolean isFrozenLockFile() {
        return GradleUtil.toBoolean(this._frozenLockFile);
    }

    public void setFrozenLockFile(Object frozenLockFile) {
        this._frozenLockFile = frozenLockFile;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("install");
        if (this.isFrozenLockFile()) {
            completeArgs.add("--frozen-lockfile");
        }
        completeArgs.add("--ignore-engines");
        return completeArgs;
    }

    private void _createYarnrcFile(File yarnrcFile) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        contents.add("disable-self-update-check true");
        contents.add("yarn-offline-mirror \"./node_modules_cache\"");
        contents.add("yarn-offline-mirror-pruning true");
        FileUtil.write((File)yarnrcFile, contents);
    }

    private File _getYarnrcFile() {
        return new File(this.getWorkingDir(), ".yarnrc");
    }
}

