/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.DigestUtil;
import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.PackageRunTask;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class PackageRunBuildTask
extends PackageRunTask {
    private static final String[] _EXCLUDE_DIR_NAMES = new String[]{"bin", "build", "classes", "node_modules", "node_modules_cache", "test-classes", "tmp"};
    private static final String[] _INCLUDES = new String[]{"**/*.*rc", "**/*.css", "**/*.js", "**/*.json", "**/*.jsx", "**/*.soy"};
    private Object _nodeVersion;
    private final PatternFilterable _patternFilterable = new PatternSet();

    public PackageRunBuildTask() {
        this.setScriptName("build");
        this._patternFilterable.exclude(_EXCLUDE_DIR_NAMES);
        this._patternFilterable.include(_INCLUDES);
    }

    @Override
    public void executeNode() throws Exception {
        String digest = DigestUtil.getDigest((Iterable<File>)this.getSourceFiles());
        super.executeNode();
        File digestFile = this.getDigestFile();
        FileUtil.write(digestFile, digest.getBytes(StandardCharsets.UTF_8));
    }

    @OutputFile
    public File getDigestFile() {
        Project project = this.getProject();
        return new File(project.getBuildDir(), "node/" + this.getName() + "/.digest");
    }

    @Input
    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    @InputFiles
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        ConfigurableFileTree fileTree = project.fileTree((Object)project.getProjectDir());
        FileTree fileCollection = fileTree.matching(this._patternFilterable);
        if (fileCollection.isEmpty()) {
            return null;
        }
        return fileCollection;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }
}

