/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;

public class DownloadNodeModuleTask
extends ExecuteNpmTask {
    private Object _moduleName;
    private Object _moduleVersion;

    public DownloadNodeModuleTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                try {
                    File packageJSONFile = new File(DownloadNodeModuleTask.this.getModuleDir(), "package.json");
                    if (!packageJSONFile.exists()) {
                        return true;
                    }
                    String packageJSON = new String(Files.readAllBytes(packageJSONFile.toPath()));
                    String version = DownloadNodeModuleTask.this.getModuleVersion();
                    return !packageJSON.contains("\"version\": \"" + version + "\"");
                }
                catch (Exception e) {
                    throw new GradleException(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    @OutputDirectory
    public File getModuleDir() {
        File nodeModulesDir = new File(this.getWorkingDir(), "node_modules");
        return new File(nodeModulesDir, this.getModuleName());
    }

    @Input
    public String getModuleName() {
        return GradleUtil.toString((Object)this._moduleName);
    }

    @Input
    public String getModuleVersion() {
        return GradleUtil.toString((Object)this._moduleVersion);
    }

    public void setModuleName(Object moduleName) {
        this._moduleName = moduleName;
    }

    public void setModuleVersion(Object moduleVersion) {
        this._moduleVersion = moduleVersion;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("install");
        completeArgs.add(this.getModuleName() + "@" + this.getModuleVersion());
        return completeArgs;
    }
}

