/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.plugins.node.internal.util.StringUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.NpmLinkTask;
import com.liferay.gradle.plugins.node.tasks.NpmRunTask;
import com.liferay.gradle.plugins.node.tasks.NpmShrinkwrapTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.util.VersionNumber;

public class NodePlugin
implements Plugin<Project> {
    public static final String CLEAN_NPM_TASK_NAME = "cleanNPM";
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    public static final String NPM_LINKS_TASK_NAME = "npmLinks";
    public static final String NPM_PACKAGE_LOCK_TASK_NAME = "npmPackageLock";
    public static final String NPM_RUN_BUILD_TASK_NAME = "npmRunBuild";
    public static final String NPM_SHRINKWRAP_TASK_NAME = "npmShrinkwrap";
    private static final String _NPM_RUN_TEST_TASK_NAME = "npmRunTest";
    private static final VersionNumber _node8VersionNumber = VersionNumber.version((int)8);
    private static final VersionNumber _npm5VersionNumber = VersionNumber.version((int)5);
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        final DownloadNodeTask downloadNodeTask = this._addTaskDownloadNode(project, nodeExtension);
        Delete cleanNpmTask = this._addTaskCleanNpm(project);
        NpmInstallTask npmInstallTask = this._addTaskNpmInstall(project, cleanNpmTask);
        Map packageJsonMap = null;
        File packageJsonFile = npmInstallTask.getPackageJsonFile();
        if (packageJsonFile.exists()) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        }
        this._addTaskNpmPackageLock(project, cleanNpmTask, npmInstallTask);
        this._addTaskNpmShrinkwrap(project, cleanNpmTask, npmInstallTask);
        this._addTasksNpmRun(npmInstallTask, packageJsonMap);
        this._configureTasksDownloadNodeModule(project, npmInstallTask, packageJsonMap);
        this._configureTasksExecuteNode(project, nodeExtension, GradleUtil.isRunningInsideDaemon());
        this._configureTasksExecuteNpm(project, nodeExtension);
        this._configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this._configureTaskDownloadNodeGlobal(downloadNodeTask, nodeExtension);
                NodePlugin.this._configureTasksExecuteNpmArgs(project, nodeExtension);
                NodePlugin.this._configureTasksNpmInstall(project, nodeExtension);
                NodePlugin.this._configureTasksNpmRun(project, nodeExtension);
            }
        });
    }

    private Delete _addTaskCleanNpm(Project project) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_NPM_TASK_NAME, Delete.class);
        delete.delete(new Object[]{"node_modules", "npm-shrinkwrap.json", "package-lock.json"});
        delete.setDescription("Deletes NPM files from this project.");
        return delete;
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, NodeExtension nodeExtension) {
        return this._addTaskDownloadNode(project, DOWNLOAD_NODE_TASK_NAME, nodeExtension);
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, String taskName, final NodeExtension nodeExtension) {
        DownloadNodeTask downloadNodeTask = (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)taskName, DownloadNodeTask.class);
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
        downloadNodeTask.setNpmUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNpmUrl();
            }
        });
        downloadNodeTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return nodeExtension.isDownload();
            }
        });
        downloadNodeTask.setDescription("Downloads Node.js in the project build directory.");
        return downloadNodeTask;
    }

    private NpmInstallTask _addTaskNpmInstall(Project project, Delete cleanNpmTask) {
        NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, NpmInstallTask.class);
        npmInstallTask.mustRunAfter(new Object[]{cleanNpmTask});
        npmInstallTask.setDescription("Installs Node packages from package.json.");
        npmInstallTask.setNpmInstallRetries(2);
        return npmInstallTask;
    }

    private ExecuteNpmTask _addTaskNpmLink(String dependencyName, NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String suffix = StringUtil.camelCase(dependencyName, true);
        NpmLinkTask npmLinkTask = (NpmLinkTask)GradleUtil.addTask((Project)project, (String)("npmLink" + suffix), NpmLinkTask.class);
        npmLinkTask.dependsOn(new Object[]{npmInstallTask});
        npmLinkTask.setDescription("Links the \"" + dependencyName + "\" NPM dependency.");
        npmLinkTask.setGroup("build");
        npmLinkTask.setDependencyName(dependencyName);
        return npmLinkTask;
    }

    private Task _addTaskNpmLinks(Set<String> dependencyNames, Project project) {
        Task task = project.task(NPM_LINKS_TASK_NAME);
        task.setDescription("Links all the NPM dependencies.");
        task.setGroup("build");
        Pattern pattern = null;
        String taskNameRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"task.name.regex");
        if (Validator.isNotNull((String)taskNameRegex)) {
            pattern = Pattern.compile(taskNameRegex);
        }
        for (String dependencyName : dependencyNames) {
            Matcher matcher;
            String suffix = StringUtil.camelCase(dependencyName, true);
            String taskName = "npmLink" + suffix;
            if (pattern != null && !(matcher = pattern.matcher(taskName)).find()) continue;
            task.dependsOn(new Object[]{taskName});
        }
        return task;
    }

    private Task _addTaskNpmPackageLock(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        Task task = project.task(NPM_PACKAGE_LOCK_TASK_NAME);
        task.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        task.setDescription("Deletes NPM files and installs Node packages from package.json.");
        return task;
    }

    private ExecuteNpmTask _addTaskNpmRun(String scriptName, NpmInstallTask npmInstallTask) {
        final Project project = npmInstallTask.getProject();
        String taskName = "npmRun" + StringUtil.camelCase(scriptName, true);
        final NpmRunTask npmRunTask = (NpmRunTask)GradleUtil.addTask((Project)project, (String)taskName, NpmRunTask.class);
        npmRunTask.dependsOn(new Object[]{npmInstallTask});
        npmRunTask.setDescription("Runs the \"" + scriptName + "\" NPM script.");
        npmRunTask.setGroup("build");
        npmRunTask.setScriptName(scriptName);
        npmRunTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                NpmRunTask npmRunTask = (NpmRunTask)task;
                String result = npmRunTask.getResult();
                if (result.contains("errors during Soy compilation")) {
                    project.delete(new Object[]{npmRunTask.getSourceDigestFile()});
                    throw new GradleException("Soy compile error");
                }
            }
        });
        if (taskName.equals(NPM_RUN_BUILD_TASK_NAME)) {
            PluginContainer pluginContainer = project.getPlugins();
            pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                public void execute(JavaPlugin javaPlugin) {
                    NodePlugin.this._configureTaskNpmRunBuildForJavaPlugin(npmRunTask);
                }
            });
        } else if (taskName.equals(_NPM_RUN_TEST_TASK_NAME)) {
            PluginContainer pluginContainer = project.getPlugins();
            pluginContainer.withType(LifecycleBasePlugin.class, (Action)new Action<LifecycleBasePlugin>(){

                public void execute(LifecycleBasePlugin lifecycleBasePlugin) {
                    NodePlugin.this._configureTaskNpmRunTestForLifecycleBasePlugin(npmRunTask);
                }
            });
        }
        return npmRunTask;
    }

    private NpmShrinkwrapTask _addTaskNpmShrinkwrap(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        NpmShrinkwrapTask npmShrinkwrapTask = (NpmShrinkwrapTask)GradleUtil.addTask((Project)project, (String)NPM_SHRINKWRAP_TASK_NAME, NpmShrinkwrapTask.class);
        npmShrinkwrapTask.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        npmShrinkwrapTask.setDescription("Locks down the versions of a package's dependencies in order to control which versions of each dependency will be used.");
        return npmShrinkwrapTask;
    }

    private void _addTasksNpmRun(NpmInstallTask npmInstallTask, Map<String, Object> packageJsonMap) {
        Map scriptsJsonMap;
        if (packageJsonMap == null) {
            return;
        }
        Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
        if (dependenciesJsonMap != null) {
            Set<String> dependencyNames = dependenciesJsonMap.keySet();
            for (String dependencyName : dependencyNames) {
                this._addTaskNpmLink(dependencyName, npmInstallTask);
            }
            this._addTaskNpmLinks(dependencyNames, npmInstallTask.getProject());
        }
        if ((scriptsJsonMap = (Map)packageJsonMap.get("scripts")) != null) {
            for (String scriptName : scriptsJsonMap.keySet()) {
                this._addTaskNpmRun(scriptName, npmInstallTask);
            }
        }
    }

    private void _configureTaskDownloadNodeGlobal(DownloadNodeTask downloadNodeTask, NodeExtension nodeExtension) {
        Project project = downloadNodeTask.getProject();
        if (!nodeExtension.isDownload() || !nodeExtension.isGlobal() || project.getParent() == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        DownloadNodeTask rootDownloadNodeTask = null;
        TaskContainer taskContainer = rootProject.getTasks();
        TaskCollection rootDownloadNodeTasks = taskContainer.withType(DownloadNodeTask.class);
        File nodeDir = downloadNodeTask.getNodeDir();
        String nodeUrl = downloadNodeTask.getNodeUrl();
        for (DownloadNodeTask curRootDownloadNodeTask : rootDownloadNodeTasks) {
            if (!nodeDir.equals(curRootDownloadNodeTask.getNodeDir()) || !nodeUrl.equals(curRootDownloadNodeTask.getNodeUrl())) continue;
            rootDownloadNodeTask = curRootDownloadNodeTask;
            break;
        }
        if (rootDownloadNodeTask == null) {
            String taskName = DOWNLOAD_NODE_TASK_NAME;
            if (!rootDownloadNodeTasks.isEmpty()) {
                taskName = taskName + rootDownloadNodeTasks.size();
            }
            rootDownloadNodeTask = this._addTaskDownloadNode(rootProject, taskName, nodeExtension);
        }
        downloadNodeTask.setActions(Collections.emptyList());
        downloadNodeTask.dependsOn(new Object[]{rootDownloadNodeTask});
    }

    private void _configureTaskDownloadNodeModule(DownloadNodeModuleTask downloadNodeModuleTask, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        downloadNodeModuleTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)task;
                File moduleDir = downloadNodeModuleTask.getModuleDir();
                File moduleParentDir = moduleDir.getParentFile();
                if (!moduleParentDir.equals(npmInstallTask.getNodeModulesDir())) {
                    return true;
                }
                if (packageJsonMap == null) {
                    return true;
                }
                String moduleName = downloadNodeModuleTask.getModuleName();
                Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
                if (dependenciesJsonMap != null && dependenciesJsonMap.containsKey(moduleName)) {
                    return false;
                }
                dependenciesJsonMap = (Map)packageJsonMap.get("devDependencies");
                return dependenciesJsonMap == null || !dependenciesJsonMap.containsKey(moduleName);
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension, boolean useGradleExec) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isDownload()) {
                    return nodeExtension.getNodeDir();
                }
                return null;
            }
        });
        executeNodeTask.setUseGradleExec(useGradleExec);
    }

    private void _configureTaskExecuteNpm(final ExecuteNpmTask executeNpmTask, final NodeExtension nodeExtension) {
        final Callable<Boolean> useGlobalConcurrentCacheCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int value1 = _node8VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNodeVersion()));
                int value2 = _npm5VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNpmVersion()));
                if (value1 <= 0 || value2 <= 0) {
                    return true;
                }
                return false;
            }
        };
        executeNpmTask.setCacheConcurrent(useGlobalConcurrentCacheCallable);
        executeNpmTask.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (((Boolean)useGlobalConcurrentCacheCallable.call()).booleanValue()) {
                    return null;
                }
                File nodeDir = executeNpmTask.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(nodeDir, ".cache");
            }
        });
    }

    private void _configureTaskExecuteNpmArgs(ExecuteNpmTask executeNpmTask, NodeExtension nodeExtension) {
        if (!NodePluginUtil.isYarnScriptFile(executeNpmTask.getScriptFile())) {
            executeNpmTask.args(nodeExtension.getNpmArgs());
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask, NodeExtension nodeExtension) {
        npmInstallTask.setNodeVersion(nodeExtension.getNodeVersion());
        npmInstallTask.setNpmVersion(nodeExtension.getNpmVersion());
    }

    private void _configureTaskNpmRun(NpmRunTask npmRunTask, NodeExtension nodeExtension) {
        SourceSet sourceSet;
        SourceSetOutput sourceSetOutput;
        File classesDir;
        npmRunTask.setNodeVersion(nodeExtension.getNodeVersion());
        npmRunTask.setNpmVersion(nodeExtension.getNpmVersion());
        Project project = npmRunTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        if (pluginContainer.hasPlugin(JavaPlugin.class) && !(classesDir = (sourceSetOutput = (sourceSet = GradleUtil.getSourceSet((Project)npmRunTask.getProject(), (String)"main")).getOutput()).getClassesDir()).exists()) {
            TaskOutputsInternal taskOutputs = npmRunTask.getOutputs();
            taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task task) {
                    return false;
                }
            });
        }
    }

    private void _configureTaskNpmRunBuildForJavaPlugin(NpmRunTask npmRunTask) {
        npmRunTask.mustRunAfter(new Object[]{"processResources"});
        Task classesTask = GradleUtil.getTask((Project)npmRunTask.getProject(), (String)"classes");
        classesTask.dependsOn(new Object[]{npmRunTask});
        final File sourceDigestFile = npmRunTask.getSourceDigestFile();
        final Project project = npmRunTask.getProject();
        ProcessResources processResourcesTask = (ProcessResources)GradleUtil.getTask((Project)project, (String)"processResources");
        processResourcesTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                ProcessResources processResourcesTask = (ProcessResources)task;
                final File processResourcesDir = processResourcesTask.getDestinationDir();
                final File npmRunBuildOutputsDir = new File(sourceDigestFile.getParentFile(), "outputs");
                project.delete(new Object[]{npmRunBuildOutputsDir});
                npmRunBuildOutputsDir.mkdirs();
                project.copy((Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{processResourcesDir});
                        copySpec.include(new String[]{"**/*.js"});
                        copySpec.into((Object)npmRunBuildOutputsDir);
                        copySpec.setIncludeEmptyDirs(false);
                    }
                });
            }
        });
        processResourcesTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                ProcessResources processResourcesTask = (ProcessResources)task;
                final File processResourcesDir = processResourcesTask.getDestinationDir();
                final File npmRunBuildOutputsDir = new File(sourceDigestFile.getParentFile(), "outputs");
                project.copy((Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{npmRunBuildOutputsDir});
                        copySpec.into((Object)processResourcesDir);
                    }
                });
            }
        });
    }

    private void _configureTaskNpmRunTestForLifecycleBasePlugin(ExecuteNpmTask executeNpmTask) {
        Task checkTask = GradleUtil.getTask((Project)executeNpmTask.getProject(), (String)"check");
        checkTask.dependsOn(new Object[]{executeNpmTask});
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String moduleName = _osgiHelper.getBundleSymbolicName(project);
                int pos = moduleName.indexOf(46);
                if (pos != -1) {
                    moduleName = moduleName.substring(pos + 1);
                    moduleName = moduleName.replace('.', '-');
                }
                return moduleName;
            }
        });
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    private void _configureTasksDownloadNodeModule(Project project, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeModuleTask.class, (Action)new Action<DownloadNodeModuleTask>(){

            public void execute(DownloadNodeModuleTask downloadNodeModuleTask) {
                NodePlugin.this._configureTaskDownloadNodeModule(downloadNodeModuleTask, npmInstallTask, packageJsonMap);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project, final NodeExtension nodeExtension, final boolean useGradleExec) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this._configureTaskExecuteNode(executeNodeTask, nodeExtension, useGradleExec);
            }
        });
    }

    private void _configureTasksExecuteNpm(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this._configureTaskExecuteNpm(executeNpmTask, nodeExtension);
            }
        });
    }

    private void _configureTasksExecuteNpmArgs(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this._configureTaskExecuteNpmArgs(executeNpmTask, nodeExtension);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodePlugin.this._configureTaskNpmInstall(npmInstallTask, nodeExtension);
            }
        });
    }

    private void _configureTasksNpmRun(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmRunTask.class, (Action)new Action<NpmRunTask>(){

            public void execute(NpmRunTask npmRunTask) {
                NodePlugin.this._configureTaskNpmRun(npmRunTask, nodeExtension);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }
}

