/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class ExecuteNpmTask
extends ExecuteNodeScriptTask {
    private Object _cacheConcurrent;
    private Object _cacheDir;
    private Object _logLevel;
    private boolean _production;
    private boolean _progress = true;
    private Object _registry;

    public ExecuteNpmTask() {
        this.setCommand(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (ExecuteNpmTask.this.getNodeDir() == null) {
                    return "npm";
                }
                return "node";
            }
        });
        this.setLogLevel(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String logLevel = null;
                Logger logger = ExecuteNpmTask.this.getLogger();
                if (logger.isTraceEnabled()) {
                    logLevel = "silly";
                } else if (logger.isDebugEnabled()) {
                    logLevel = "verbose";
                } else if (logger.isInfoEnabled()) {
                    logLevel = "info";
                } else if (logger.isWarnEnabled()) {
                    logLevel = "warn";
                } else if (logger.isErrorEnabled()) {
                    logLevel = "error";
                }
                return logLevel;
            }
        });
        this.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = ExecuteNpmTask.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(NodePluginUtil.getNpmDir(nodeDir), "bin/npm-cli.js");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeNode() throws Exception {
        Project project = this.getProject();
        File cacheDir = this.getCacheDir();
        if (this.isCacheConcurrent() || cacheDir != null && FileUtil.isChild((File)cacheDir, (File)project.getProjectDir())) {
            super.executeNode();
            return;
        }
        Class<ExecuteNpmTask> clazz = ExecuteNpmTask.class;
        synchronized (ExecuteNpmTask.class) {
            super.executeNode();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public File getCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._cacheDir);
    }

    public String getLogLevel() {
        return GradleUtil.toString((Object)this._logLevel);
    }

    public String getRegistry() {
        return GradleUtil.toString((Object)this._registry);
    }

    public boolean isCacheConcurrent() {
        return GradleUtil.toBoolean(this._cacheConcurrent);
    }

    public boolean isProduction() {
        return this._production;
    }

    public boolean isProgress() {
        return this._progress;
    }

    public void setCacheConcurrent(Object cacheConcurrent) {
        this._cacheConcurrent = cacheConcurrent;
    }

    public void setCacheDir(Object cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setLogLevel(Object logLevel) {
        this._logLevel = logLevel;
    }

    public void setProduction(boolean production) {
        this._production = production;
    }

    public void setProgress(boolean progress) {
        this._progress = progress;
    }

    public void setRegistry(Object registry) {
        this._registry = registry;
    }

    @Override
    protected List<String> getCompleteArgs() {
        String logLevel;
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("--production");
        completeArgs.add(Boolean.toString(this.isProduction()));
        String registry = this.getRegistry();
        if (Validator.isNotNull((String)registry)) {
            completeArgs.add("--registry");
            completeArgs.add(registry);
        }
        if (NodePluginUtil.isYarnScriptFile(this.getScriptFile())) {
            return completeArgs;
        }
        File cacheDir = this.getCacheDir();
        if (cacheDir != null) {
            completeArgs.add("--cache");
            completeArgs.add(FileUtil.getAbsolutePath((File)cacheDir));
        }
        if (Validator.isNotNull((String)(logLevel = this.getLogLevel()))) {
            completeArgs.add("--loglevel");
            completeArgs.add(logLevel);
        }
        completeArgs.add("--progress");
        completeArgs.add(Boolean.toString(this.isProgress()));
        return completeArgs;
    }
}

