/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.NpmShrinkwrapTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.StringUtil;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.util.VersionNumber;

public class NodePlugin
implements Plugin<Project> {
    public static final String CLEAN_NPM_TASK_NAME = "cleanNPM";
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    public static final String NPM_RUN_BUILD_TASK_NAME = "npmRunBuild";
    public static final String NPM_SHRINKWRAP_TASK_NAME = "npmShrinkwrap";
    private static final String _NPM_RUN_TEST_TASK_NAME = "npmRunTest";
    private static final VersionNumber _node8VersionNumber = VersionNumber.version((int)8);
    private static final VersionNumber _npm5VersionNumber = VersionNumber.version((int)5);
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        final DownloadNodeTask downloadNodeTask = this._addTaskDownloadNode(project, nodeExtension);
        Delete cleanNpmTask = this._addTaskCleanNpm(project);
        NpmInstallTask npmInstallTask = this._addTaskNpmInstall(project, cleanNpmTask);
        Map packageJsonMap = null;
        File packageJsonFile = npmInstallTask.getPackageJsonFile();
        if (packageJsonFile.exists()) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        }
        this._addTaskNpmShrinkwrap(project, cleanNpmTask, npmInstallTask);
        this._addTasksNpmRun(npmInstallTask, packageJsonMap);
        this._configureTasksDownloadNodeModule(project, npmInstallTask, packageJsonMap);
        this._configureTasksExecuteNode(project, nodeExtension, GradleUtil.isRunningInsideDaemon());
        this._configureTasksExecuteNpm(project, nodeExtension);
        this._configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this._configureTaskDownloadNodeGlobal(downloadNodeTask, nodeExtension);
                NodePlugin.this._configureTasksExecuteNpmArgs(project, nodeExtension);
            }
        });
    }

    private Delete _addTaskCleanNpm(Project project) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_NPM_TASK_NAME, Delete.class);
        delete.delete(new Object[]{"node_modules", "npm-shrinkwrap.json", "package-lock.json"});
        delete.setDescription("Deletes NPM files from this project.");
        return delete;
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, NodeExtension nodeExtension) {
        return this._addTaskDownloadNode(project, DOWNLOAD_NODE_TASK_NAME, nodeExtension);
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, String taskName, final NodeExtension nodeExtension) {
        DownloadNodeTask downloadNodeTask = (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)taskName, DownloadNodeTask.class);
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
        downloadNodeTask.setNodeExeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeExeUrl();
            }
        });
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
        downloadNodeTask.setNpmUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNpmUrl();
            }
        });
        downloadNodeTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return nodeExtension.isDownload();
            }
        });
        downloadNodeTask.setDescription("Downloads Node.js in the project build directory.");
        return downloadNodeTask;
    }

    private NpmInstallTask _addTaskNpmInstall(Project project, Delete cleanNpmTask) {
        NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, NpmInstallTask.class);
        npmInstallTask.mustRunAfter(new Object[]{cleanNpmTask});
        npmInstallTask.setDescription("Installs Node packages from package.json.");
        npmInstallTask.setNpmInstallRetries(2);
        return npmInstallTask;
    }

    private ExecuteNpmTask _addTaskNpmRun(String name, NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String taskName = "npmRun" + StringUtil.capitalize((String)name);
        final ExecuteNpmTask executeNpmTask = (ExecuteNpmTask)GradleUtil.addTask((Project)project, (String)taskName, ExecuteNpmTask.class);
        executeNpmTask.dependsOn(new Object[]{npmInstallTask});
        executeNpmTask.setArgs("run-script", name);
        executeNpmTask.setDescription("Runs the \"" + name + "\" NPM script.");
        executeNpmTask.setGroup("build");
        if (taskName.equals(NPM_RUN_BUILD_TASK_NAME)) {
            PluginContainer pluginContainer = project.getPlugins();
            pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                public void execute(JavaPlugin javaPlugin) {
                    NodePlugin.this._configureTaskNpmRunBuildForJavaPlugin(executeNpmTask);
                }
            });
        } else if (taskName.equals(_NPM_RUN_TEST_TASK_NAME)) {
            PluginContainer pluginContainer = project.getPlugins();
            pluginContainer.withType(LifecycleBasePlugin.class, (Action)new Action<LifecycleBasePlugin>(){

                public void execute(LifecycleBasePlugin lifecycleBasePlugin) {
                    NodePlugin.this._configureTaskNpmRunTestForLifecycleBasePlugin(executeNpmTask);
                }
            });
        }
        return executeNpmTask;
    }

    private NpmShrinkwrapTask _addTaskNpmShrinkwrap(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        NpmShrinkwrapTask npmShrinkwrapTask = (NpmShrinkwrapTask)GradleUtil.addTask((Project)project, (String)NPM_SHRINKWRAP_TASK_NAME, NpmShrinkwrapTask.class);
        npmShrinkwrapTask.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        npmShrinkwrapTask.setDescription("Locks down the versions of a package's dependencies in order to control which versions of each dependency will be used.");
        return npmShrinkwrapTask;
    }

    private void _addTasksNpmRun(NpmInstallTask npmInstallTask, Map<String, Object> packageJsonMap) {
        if (packageJsonMap == null) {
            return;
        }
        Map scriptsJsonMap = (Map)packageJsonMap.get("scripts");
        if (scriptsJsonMap == null) {
            return;
        }
        for (String name : scriptsJsonMap.keySet()) {
            this._addTaskNpmRun(name, npmInstallTask);
        }
    }

    private void _configureTaskDownloadNodeGlobal(DownloadNodeTask downloadNodeTask, NodeExtension nodeExtension) {
        Project project = downloadNodeTask.getProject();
        if (!nodeExtension.isDownload() || !nodeExtension.isGlobal() || project.getParent() == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        DownloadNodeTask rootDownloadNodeTask = null;
        TaskContainer taskContainer = rootProject.getTasks();
        TaskCollection rootDownloadNodeTasks = taskContainer.withType(DownloadNodeTask.class);
        File nodeDir = downloadNodeTask.getNodeDir();
        String nodeExeUrl = downloadNodeTask.getNodeExeUrl();
        String nodeUrl = downloadNodeTask.getNodeUrl();
        for (DownloadNodeTask curRootDownloadNodeTask : rootDownloadNodeTasks) {
            if (!nodeDir.equals(curRootDownloadNodeTask.getNodeDir()) || !nodeExeUrl.equals(curRootDownloadNodeTask.getNodeExeUrl()) || !nodeUrl.equals(curRootDownloadNodeTask.getNodeUrl())) continue;
            rootDownloadNodeTask = curRootDownloadNodeTask;
            break;
        }
        if (rootDownloadNodeTask == null) {
            String taskName = DOWNLOAD_NODE_TASK_NAME;
            if (!rootDownloadNodeTasks.isEmpty()) {
                taskName = taskName + rootDownloadNodeTasks.size();
            }
            rootDownloadNodeTask = this._addTaskDownloadNode(rootProject, taskName, nodeExtension);
        }
        downloadNodeTask.deleteAllActions();
        downloadNodeTask.dependsOn(new Object[]{rootDownloadNodeTask});
    }

    private void _configureTaskDownloadNodeModule(DownloadNodeModuleTask downloadNodeModuleTask, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        downloadNodeModuleTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)task;
                File moduleDir = downloadNodeModuleTask.getModuleDir();
                File moduleParentDir = moduleDir.getParentFile();
                if (!moduleParentDir.equals(npmInstallTask.getNodeModulesDir())) {
                    return true;
                }
                if (packageJsonMap == null) {
                    return true;
                }
                String moduleName = downloadNodeModuleTask.getModuleName();
                Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
                if (dependenciesJsonMap != null && dependenciesJsonMap.containsKey(moduleName)) {
                    return false;
                }
                dependenciesJsonMap = (Map)packageJsonMap.get("devDependencies");
                return dependenciesJsonMap == null || !dependenciesJsonMap.containsKey(moduleName);
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension, boolean useGradleExec) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isDownload()) {
                    return nodeExtension.getNodeDir();
                }
                return null;
            }
        });
        executeNodeTask.setUseGradleExec(useGradleExec);
    }

    private void _configureTaskExecuteNpm(final ExecuteNpmTask executeNpmTask, final NodeExtension nodeExtension) {
        final Callable<Boolean> useGlobalConcurrentCacheCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (_node8VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNodeVersion())) <= 0 || _npm5VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNpmVersion())) <= 0) {
                    return true;
                }
                return false;
            }
        };
        executeNpmTask.setCacheConcurrent(useGlobalConcurrentCacheCallable);
        executeNpmTask.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (((Boolean)useGlobalConcurrentCacheCallable.call()).booleanValue()) {
                    return null;
                }
                File nodeDir = executeNpmTask.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(nodeDir, ".cache");
            }
        });
    }

    private void _configureTaskExecuteNpmArgs(ExecuteNpmTask executeNpmTask, NodeExtension nodeExtension) {
        executeNpmTask.args(nodeExtension.getNpmArgs());
    }

    private void _configureTaskNpmRunBuildForJavaPlugin(ExecuteNpmTask executeNpmTask) {
        executeNpmTask.mustRunAfter(new Object[]{"processResources"});
        Task classesTask = GradleUtil.getTask((Project)executeNpmTask.getProject(), (String)"classes");
        classesTask.dependsOn(new Object[]{executeNpmTask});
    }

    private void _configureTaskNpmRunTestForLifecycleBasePlugin(ExecuteNpmTask executeNpmTask) {
        Task checkTask = GradleUtil.getTask((Project)executeNpmTask.getProject(), (String)"check");
        checkTask.dependsOn(new Object[]{executeNpmTask});
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String moduleName = _osgiHelper.getBundleSymbolicName(project);
                int pos = moduleName.indexOf(46);
                if (pos != -1) {
                    moduleName = moduleName.substring(pos + 1);
                    moduleName = moduleName.replace('.', '-');
                }
                return moduleName;
            }
        });
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    private void _configureTasksDownloadNodeModule(Project project, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeModuleTask.class, (Action)new Action<DownloadNodeModuleTask>(){

            public void execute(DownloadNodeModuleTask downloadNodeModuleTask) {
                NodePlugin.this._configureTaskDownloadNodeModule(downloadNodeModuleTask, npmInstallTask, packageJsonMap);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project, final NodeExtension nodeExtension, final boolean useGradleExec) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this._configureTaskExecuteNode(executeNodeTask, nodeExtension, useGradleExec);
            }
        });
    }

    private void _configureTasksExecuteNpm(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this._configureTaskExecuteNpm(executeNpmTask, nodeExtension);
            }
        });
    }

    private void _configureTasksExecuteNpmArgs(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this._configureTaskExecuteNpmArgs(executeNpmTask, nodeExtension);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }
}

