/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonOutput;
import groovy.lang.Writable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;

public class PublishNodeModuleTask
extends ExecuteNpmTask {
    private Object _moduleAuthor;
    private Object _moduleBugsUrl;
    private Object _moduleDescription;
    private final List<Object> _moduleKeywords = new ArrayList<Object>();
    private Object _moduleLicense;
    private Object _moduleMain;
    private Object _moduleName;
    private Object _moduleRepository;
    private Object _moduleVersion;
    private Object _npmEmailAddress;
    private Object _npmPassword;
    private Object _npmUserName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNode() throws Exception {
        File packageJsonFile = this._getPackageJsonFile();
        boolean packageJsonExists = packageJsonFile.exists();
        try {
            this._createNpmrcFile();
            if (!packageJsonExists) {
                this._createPackageJsonFile();
            }
            super.executeNode();
        }
        catch (Throwable throwable) {
            Project project = this.getProject();
            project.delete(new Object[]{this._getNpmrcFile()});
            if (!packageJsonExists) {
                project.delete(new Object[]{packageJsonFile});
            }
            throw throwable;
        }
        Project project = this.getProject();
        project.delete(new Object[]{this._getNpmrcFile()});
        if (!packageJsonExists) {
            project.delete(new Object[]{packageJsonFile});
        }
    }

    @Input
    @Optional
    public String getModuleAuthor() {
        return GradleUtil.toString((Object)this._moduleAuthor);
    }

    public String getModuleBugsUrl() {
        return GradleUtil.toString((Object)this._moduleBugsUrl);
    }

    @Input
    @Optional
    public String getModuleDescription() {
        return GradleUtil.toString((Object)this._moduleDescription);
    }

    @Input
    public List<String> getModuleKeywords() {
        return GradleUtil.toStringList(this._moduleKeywords);
    }

    @Input
    @Optional
    public String getModuleLicense() {
        return GradleUtil.toString((Object)this._moduleLicense);
    }

    @Input
    @Optional
    public String getModuleMain() {
        return GradleUtil.toString((Object)this._moduleMain);
    }

    @Input
    public String getModuleName() {
        return GradleUtil.toString((Object)this._moduleName);
    }

    @Input
    @Optional
    public String getModuleRepository() {
        return GradleUtil.toString((Object)this._moduleRepository);
    }

    @Input
    public String getModuleVersion() {
        return GradleUtil.toString((Object)this._moduleVersion);
    }

    @Input
    public String getNpmEmailAddress() {
        return GradleUtil.toString((Object)this._npmEmailAddress);
    }

    @Input
    public String getNpmPassword() {
        return GradleUtil.toString((Object)this._npmPassword);
    }

    @Input
    public String getNpmUserName() {
        return GradleUtil.toString((Object)this._npmUserName);
    }

    @Override
    @InputDirectory
    public File getWorkingDir() {
        return super.getWorkingDir();
    }

    public void setModuleAuthor(Object moduleAuthor) {
        this._moduleAuthor = moduleAuthor;
    }

    public void setModuleBugsUrl(Object moduleBugsUrl) {
        this._moduleBugsUrl = moduleBugsUrl;
    }

    public void setModuleDescription(Object moduleDescription) {
        this._moduleDescription = moduleDescription;
    }

    public void setModuleKeywords(Iterable<?> moduleKeywords) {
        this._moduleKeywords.clear();
    }

    public void setModuleKeywords(Object ... moduleKeywords) {
        this.setModuleKeywords(Arrays.asList(moduleKeywords));
    }

    public void setModuleLicense(Object moduleLicense) {
        this._moduleLicense = moduleLicense;
    }

    public void setModuleMain(Object moduleMain) {
        this._moduleMain = moduleMain;
    }

    public void setModuleName(Object moduleName) {
        this._moduleName = moduleName;
    }

    public void setModuleRepository(Object moduleRepository) {
        this._moduleRepository = moduleRepository;
    }

    public void setModuleVersion(Object moduleVersion) {
        this._moduleVersion = moduleVersion;
    }

    public void setNpmEmailAddress(Object npmEmailAddress) {
        this._npmEmailAddress = npmEmailAddress;
    }

    public void setNpmPassword(Object npmPassword) {
        this._npmPassword = npmPassword;
    }

    public void setNpmUserName(Object npmUserName) {
        this._npmUserName = npmUserName;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("publish");
        completeArgs.add("--userconfig");
        completeArgs.add(FileUtil.getAbsolutePath((File)this._getNpmrcFile()));
        return completeArgs;
    }

    private void _createNpmrcFile() throws IOException {
        ArrayList<String> npmrcContents = new ArrayList<String>(2);
        npmrcContents.add("_auth = " + this._getNpmAuth());
        npmrcContents.add("email = " + this.getNpmEmailAddress());
        npmrcContents.add("username = " + this.getNpmUserName());
        FileUtil.write((File)this._getNpmrcFile(), npmrcContents);
    }

    private void _createPackageJsonFile() throws IOException {
        String main;
        String license;
        List<String> keywords;
        String description;
        String bugsUrl;
        Logger logger = this.getLogger();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String author = this.getModuleAuthor();
        if (Validator.isNotNull((String)author)) {
            map.put("author", author);
        }
        if (Validator.isNotNull((String)(bugsUrl = this.getModuleBugsUrl()))) {
            map.put("bugs", bugsUrl);
        }
        if (Validator.isNotNull((String)(description = this.getModuleDescription()))) {
            map.put("description", description);
        }
        if (!(keywords = this.getModuleKeywords()).isEmpty()) {
            map.put("keywords", keywords);
        }
        if (Validator.isNotNull((String)(license = this.getModuleLicense()))) {
            map.put("license", license);
        }
        if (Validator.isNotNull((String)(main = this.getModuleMain()))) {
            map.put("main", main);
        }
        map.put("name", this.getModuleName());
        String repository = this.getModuleRepository();
        if (Validator.isNotNull((String)repository)) {
            map.put("repository", repository);
        }
        map.put("version", this.getModuleVersion());
        String json = JsonOutput.toJson(map);
        if (logger.isInfoEnabled()) {
            logger.info(json);
        }
        File packageJsonFile = this._getPackageJsonFile();
        Files.write(packageJsonFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private String _getNpmAuth() {
        String auth = this.getNpmUserName() + ":" + this.getNpmPassword();
        Writable writable = EncodingGroovyMethods.encodeBase64((byte[])auth.getBytes());
        return writable.toString();
    }

    private File _getNpmrcFile() {
        return new File(this.getTemporaryDir(), "npmrc");
    }

    private File _getPackageJsonFile() {
        return new File(this.getWorkingDir(), "package.json");
    }
}

