/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.NodeExecutor;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;

public class ExecuteNodeTask
extends DefaultTask {
    private final NodeExecutor _nodeExecutor = new NodeExecutor(this.getProject());
    private int _npmInstallRetries;

    public ExecuteNodeTask() {
        this.dependsOn(new Object[]{"downloadNode"});
    }

    public ExecuteNodeTask args(Iterable<?> args) {
        this._nodeExecutor.args(args);
        return this;
    }

    public ExecuteNodeTask args(Object ... args) {
        this._nodeExecutor.args(args);
        return this;
    }

    @TaskAction
    public void executeNode() throws Exception {
        int npmInstallRetries = this.getNpmInstallRetries();
        NpmInstallTask npmInstallTask = GradleUtil.fetchTask(this.getProject(), "npmInstall", NpmInstallTask.class);
        if (this instanceof ExecuteNpmTask || npmInstallRetries <= 0 || npmInstallTask == null) {
            this._nodeExecutor.execute();
            return;
        }
        Logger logger = this.getLogger();
        for (int i = 0; i < npmInstallRetries; ++i) {
            try {
                this._nodeExecutor.execute();
                break;
            }
            catch (IOException ioe) {
                if (logger.isWarnEnabled()) {
                    logger.warn(ioe.getMessage() + ". Running \"npm install\" again");
                }
                npmInstallTask.executeNpmInstall(true);
                continue;
            }
        }
    }

    public List<Object> getArgs() {
        return this._nodeExecutor.getArgs();
    }

    public String getCommand() {
        return this._nodeExecutor.getCommand();
    }

    public File getNodeDir() {
        return this._nodeExecutor.getNodeDir();
    }

    public int getNpmInstallRetries() {
        return this._npmInstallRetries;
    }

    public File getWorkingDir() {
        return this._nodeExecutor.getWorkingDir();
    }

    public boolean isInheritProxy() {
        return this._nodeExecutor.isInheritProxy();
    }

    public boolean isUseGradleExec() {
        return this._nodeExecutor.isUseGradleExec();
    }

    public void setArgs(Iterable<?> args) {
        this._nodeExecutor.setArgs(args);
    }

    public void setArgs(Object ... args) {
        this._nodeExecutor.setArgs(args);
    }

    public void setCommand(Object command) {
        this._nodeExecutor.setCommand(command);
    }

    public void setInheritProxy(boolean inheritProxy) {
        this._nodeExecutor.setInheritProxy(inheritProxy);
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeExecutor.setNodeDir(nodeDir);
    }

    public void setNpmInstallRetries(int npmInstallRetries) {
        this._npmInstallRetries = npmInstallRetries;
    }

    public void setUseGradleExec(boolean useGradleExec) {
        this._nodeExecutor.setUseGradleExec(useGradleExec);
    }

    public void setWorkingDir(Object workingDir) {
        this._nodeExecutor.setWorkingDir(workingDir);
    }
}

