/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.util.GradleUtil;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.util.GUtil;

public class NpmShrinkwrapTask
extends ExecuteNpmTask {
    private static final String _FOUR_SPACES;
    private final Set<Object> _excludedDependencies = new LinkedHashSet<Object>();
    private boolean _includeDevDependencies = true;

    public NpmShrinkwrapTask excludeDependencies(Iterable<?> excludedDependencies) {
        GUtil.addToCollection(this._excludedDependencies, (Iterable[])new Iterable[]{excludedDependencies});
        return this;
    }

    public NpmShrinkwrapTask excludeDependencies(Object ... excludedDependencies) {
        return this.excludeDependencies(Arrays.asList(excludedDependencies));
    }

    @Override
    public void executeNode() throws Exception {
        super.executeNode();
        this._removeExcludedDependencies();
    }

    @Input
    public List<String> getExcludedDependencies() {
        return GradleUtil.toStringList(this._excludedDependencies);
    }

    @Input
    public boolean isIncludeDevDependencies() {
        return this._includeDevDependencies;
    }

    public void setExcludedDependencies(Iterable<?> excludedDependencies) {
        this._excludedDependencies.clear();
        this.excludeDependencies(excludedDependencies);
    }

    public void setExcludedDependencies(Object ... excludedDependencies) {
        this.setExcludedDependencies(Arrays.asList(excludedDependencies));
    }

    public void setIncludeDevDependencies(boolean includeDevDepenencies) {
        this._includeDevDependencies = includeDevDepenencies;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("shrinkwrap");
        if (this.isIncludeDevDependencies()) {
            completeArgs.add("--dev");
        }
        return completeArgs;
    }

    private void _removeExcludedDependencies() throws IOException {
        List<String> excludedDependencies = this.getExcludedDependencies();
        if (excludedDependencies.isEmpty()) {
            return;
        }
        File shrinkwrapJsonFile = new File(this.getWorkingDir(), "npm-shrinkwrap.json");
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map shrinkwrap = (Map)jsonSlurper.parse(shrinkwrapJsonFile);
        this._removeExcludedDependencies(shrinkwrap, excludedDependencies);
        String shrinkwrapJson = JsonOutput.prettyPrint((String)JsonOutput.toJson((Map)shrinkwrap));
        shrinkwrapJson = shrinkwrapJson.replace(_FOUR_SPACES, "\t");
        Files.write(shrinkwrapJsonFile.toPath(), shrinkwrapJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _removeExcludedDependencies(Map<String, Object> map, Iterable<String> excludedDependencies) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map valueMap = (Map)value;
            if (key.equals("dependencies")) {
                for (String excludedDependency : excludedDependencies) {
                    valueMap.remove(excludedDependency);
                }
            }
            this._removeExcludedDependencies(valueMap, excludedDependencies);
        }
    }

    static {
        char[] spaces = new char[4];
        Arrays.fill(spaces, ' ');
        _FOUR_SPACES = new String(spaces);
    }
}

