/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;

public class NodePlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        this.addTaskDownloadNode(project);
        this.addTaskNpmInstall(project);
        this.configureTasksDownloadNode(project, nodeExtension);
        this.configureTasksExecuteNode(project, nodeExtension);
        this.configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this.configureTasksExecuteNpm(project, nodeExtension);
            }
        });
    }

    protected DownloadNodeTask addTaskDownloadNode(Project project) {
        return (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_NODE_TASK_NAME, DownloadNodeTask.class);
    }

    protected ExecuteNpmTask addTaskNpmInstall(Project project) {
        final ExecuteNpmTask executeNpmTask = (ExecuteNpmTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, ExecuteNpmTask.class);
        executeNpmTask.setArgs("install");
        executeNpmTask.setDescription("Install Node packages from package.json.");
        TaskInputs taskInputs = executeNpmTask.getInputs();
        taskInputs.file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(executeNpmTask.getWorkingDir(), "package.json");
            }
        });
        TaskOutputsInternal taskOutputs = executeNpmTask.getOutputs();
        taskOutputs.dir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(executeNpmTask.getWorkingDir(), "node_modules");
            }
        });
        return executeNpmTask;
    }

    protected void configureTaskDownloadNodeDir(DownloadNodeTask downloadNodeTask, final NodeExtension nodeExtension) {
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
    }

    protected void configureTaskDownloadNodeNpmUrl(DownloadNodeTask downloadNodeTask, final NodeExtension nodeExtension) {
        downloadNodeTask.setNpmUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNpmUrl();
            }
        });
    }

    protected void configureTaskDownloadNodeUrl(DownloadNodeTask downloadNodeTask, final NodeExtension nodeExtension) {
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
    }

    protected void configureTaskExecuteNodeDir(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
    }

    protected void configureTaskExecuteNpmArgs(ExecuteNpmTask executeNpmTask, NodeExtension nodeExtension) {
        executeNpmTask.args(nodeExtension.getNpmArgs());
    }

    protected void configureTaskPublishNodeModuleDescription(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
    }

    protected void configureTaskPublishNodeModuleName(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName();
            }
        });
    }

    protected void configureTaskPublishNodeModuleVersion(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    protected void configureTasksDownloadNode(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeTask.class, (Action)new Action<DownloadNodeTask>(){

            public void execute(DownloadNodeTask downloadNodeTask) {
                NodePlugin.this.configureTaskDownloadNodeDir(downloadNodeTask, nodeExtension);
                NodePlugin.this.configureTaskDownloadNodeNpmUrl(downloadNodeTask, nodeExtension);
                NodePlugin.this.configureTaskDownloadNodeUrl(downloadNodeTask, nodeExtension);
            }
        });
    }

    protected void configureTasksExecuteNode(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this.configureTaskExecuteNodeDir(executeNodeTask, nodeExtension);
            }
        });
    }

    protected void configureTasksExecuteNpm(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this.configureTaskExecuteNpmArgs(executeNpmTask, nodeExtension);
            }
        });
    }

    protected void configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this.configureTaskPublishNodeModuleDescription(publishNodeModuleTask);
                NodePlugin.this.configureTaskPublishNodeModuleName(publishNodeModuleTask);
                NodePlugin.this.configureTaskPublishNodeModuleVersion(publishNodeModuleTask);
            }
        });
    }
}

