/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.util.GUtil;

public class NodeExtension {
    private Object _nodeDir;
    private Object _nodeUrl;
    private Object _nodeVersion = "0.12.6";
    private final List<Object> _npmArgs = new ArrayList<Object>();
    private Object _npmUrl;
    private Object _npmVersion = "1.4.9";
    private final Project _project;

    public NodeExtension(final Project project) {
        this._nodeDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "node");
            }
        };
        this._nodeUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String nodeVersion = NodeExtension.this.getNodeVersion();
                if (Validator.isNull((String)nodeVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("http://nodejs.org/dist/v");
                sb.append(nodeVersion);
                sb.append('/');
                String bitmode = OSDetector.getBitmode();
                if (OSDetector.isWindows()) {
                    if (bitmode.equals("64")) {
                        sb.append("x64/");
                    }
                    sb.append("node.exe");
                } else {
                    sb.append("/node-v");
                    sb.append(nodeVersion);
                    sb.append('-');
                    String os = "linux";
                    if (OSDetector.isApple()) {
                        os = "darwin";
                    }
                    sb.append(os);
                    sb.append("-x");
                    if (bitmode.equals("32")) {
                        bitmode = "86";
                    }
                    sb.append(bitmode);
                    sb.append(".tar.gz");
                }
                return sb.toString();
            }
        };
        this._npmUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String npmVersion = NodeExtension.this.getNpmVersion();
                if (Validator.isNull((String)npmVersion)) {
                    return null;
                }
                return "http://nodejs.org/dist/npm/npm-" + npmVersion + ".zip";
            }
        };
        this._project = project;
        this.setNpmArgs("--cache", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return FileUtil.getAbsolutePath((File)NodeExtension.this.getNpmCacheDir());
            }
        });
    }

    public File getNodeDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._nodeDir);
    }

    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    public List<String> getNpmArgs() {
        return GradleUtil.toStringList(this._npmArgs);
    }

    public String getNpmUrl() {
        return GradleUtil.toString((Object)this._npmUrl);
    }

    public String getNpmVersion() {
        return GradleUtil.toString((Object)this._npmVersion);
    }

    public NodeExtension npmArgs(Iterable<?> npmArgs) {
        GUtil.addToCollection(this._npmArgs, (Iterable[])new Iterable[]{npmArgs});
        return this;
    }

    public NodeExtension npmArgs(Object ... npmArgs) {
        return this.npmArgs(Arrays.asList(npmArgs));
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }

    public void setNpmArgs(Iterable<?> npmArgs) {
        this._npmArgs.clear();
        this.npmArgs(npmArgs);
    }

    public void setNpmArgs(Object ... npmArgs) {
        this.setNpmArgs(Arrays.asList(npmArgs));
    }

    public void setNpmUrl(Object npmUrl) {
        this._npmUrl = npmUrl;
    }

    public void setNpmVersion(Object npmVersion) {
        this._npmVersion = npmVersion;
    }

    protected File getNpmCacheDir() {
        return new File(this.getNodeDir(), ".cache");
    }
}

