/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.util;

import com.liferay.gradle.plugins.node.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.util.GUtil;

public class NodeExecutor {
    private static final String[] _PATH_KEYS = new String[]{"Path", "PATH"};
    private final List<Object> _args = new ArrayList<Object>();
    private Object _command = "node";
    private Object _nodeDir;
    private final Project _project;
    private Object _workingDir;

    public NodeExecutor(Project project) {
        this._project = project;
        this._workingDir = this._project.getProjectDir();
    }

    public NodeExecutor args(Iterable<?> args) {
        GUtil.addToCollection(this._args, (Iterable[])new Iterable[]{args});
        return this;
    }

    public NodeExecutor args(Object ... args) {
        return this.args(Arrays.asList(args));
    }

    public void execute() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandLine());
        processBuilder.inheritIO();
        processBuilder.directory(this.getWorkingDir());
        this.updateEnvironment(processBuilder.environment());
        Process process = processBuilder.start();
        process.waitFor();
    }

    public List<String> getArgs() {
        return GradleUtil.toStringList(this._args);
    }

    public String getCommand() {
        return GradleUtil.toString((Object)this._command);
    }

    public File getNodeDir() {
        return GradleUtil.toFile(this._project, this._nodeDir);
    }

    public File getWorkingDir() {
        return GradleUtil.toFile(this._project, this._workingDir);
    }

    public void setArgs(Iterable<?> args) {
        this._args.clear();
        this.args(args);
    }

    public void setArgs(Object ... args) {
        this.setArgs(Arrays.asList(args));
    }

    public void setCommand(Object command) {
        this._command = command;
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setWorkingDir(Object workingDir) {
        this._workingDir = workingDir;
    }

    protected List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            commandLine.add("cmd");
            commandLine.addAll(this.getWindowsArgs());
        } else {
            commandLine.add(this.getExecutable());
            commandLine.addAll(this.getArgs());
        }
        return commandLine;
    }

    protected String getExecutable() {
        String executable = GradleUtil.toString((Object)this._command);
        File executableDir = this.getExecutableDir();
        if (executableDir != null) {
            File executableFile = new File(executableDir, executable);
            executable = executableFile.getAbsolutePath();
        }
        return executable;
    }

    protected File getExecutableDir() {
        File nodeDir = this.getNodeDir();
        if (nodeDir == null) {
            return null;
        }
        return new File(nodeDir, "bin");
    }

    protected List<String> getWindowsArgs() {
        ArrayList<String> windowsArgs = new ArrayList<String>(2);
        windowsArgs.add("/c");
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        String executable = this.getExecutable();
        if (executable.indexOf(File.separatorChar) == -1) {
            sb.append(executable);
        } else {
            sb.append('\"');
            sb.append(executable);
            sb.append('\"');
        }
        for (String arg : this.getArgs()) {
            sb.append(" \"");
            if (Validator.isNotNull((String)arg)) {
                sb.append(arg);
            }
            sb.append('\"');
        }
        sb.append('\"');
        windowsArgs.add(sb.toString());
        return windowsArgs;
    }

    protected void updateEnvironment(Map<String, String> environment) {
        File executableDir = this.getExecutableDir();
        if (executableDir == null) {
            return;
        }
        for (String pathKey : _PATH_KEYS) {
            String path = environment.get(pathKey);
            if (Validator.isNull((String)path)) continue;
            path = executableDir.getAbsolutePath() + File.pathSeparator + path;
            environment.put(pathKey, path);
        }
    }
}

