/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.plugins.node.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;

public class ExecuteNpmTask
extends ExecuteNodeScriptTask {
    private Object _cacheDir;

    public ExecuteNpmTask() {
        this.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = ExecuteNpmTask.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(ExecuteNpmTask.this.getNodeDir(), ".cache");
            }
        });
        this.setCommand(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (ExecuteNpmTask.this.getNodeDir() == null) {
                    return "npm";
                }
                return "node";
            }
        });
        this.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = ExecuteNpmTask.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(ExecuteNpmTask.this.getNodeDir(), "lib/node_modules/npm/bin/npm-cli.js");
            }
        });
    }

    public File getCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._cacheDir);
    }

    public void setCacheDir(Object cacheDir) {
        this._cacheDir = cacheDir;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        File cacheDir = this.getCacheDir();
        if (cacheDir != null) {
            completeArgs.add("--cache");
            completeArgs.add(FileUtil.getAbsolutePath((File)cacheDir));
        }
        return completeArgs;
    }
}

