/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.util.GUtil;

public class NodeExtension {
    private boolean _download;
    private Object _nodeDir;
    private Object _nodeExeUrl;
    private Object _nodeUrl;
    private Object _nodeVersion = "5.5.0";
    private final List<Object> _npmArgs = new ArrayList<Object>();
    private final Project _project;

    public NodeExtension(final Project project) {
        this._download = GradleUtil.getProperty((ExtensionAware)project, (String)"nodeDownload", (boolean)true);
        this._nodeDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "node");
            }
        };
        this._nodeExeUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String nodeVersion = NodeExtension.this.getNodeVersion();
                if (Validator.isNull((String)nodeVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("http://nodejs.org/dist/v");
                sb.append(nodeVersion);
                sb.append('/');
                String bitmode = OSDetector.getBitmode();
                if (bitmode.equals("64")) {
                    if (nodeVersion.charAt(0) != '0') {
                        sb.append("win-x64");
                    } else {
                        sb.append("x64");
                    }
                } else if (nodeVersion.charAt(0) != '0') {
                    sb.append("win-x86");
                }
                sb.append("/node.exe");
                return sb.toString();
            }
        };
        this._nodeUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String nodeVersion = NodeExtension.this.getNodeVersion();
                if (Validator.isNull((String)nodeVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("http://nodejs.org/dist/v");
                sb.append(nodeVersion);
                sb.append("/node-v");
                sb.append(nodeVersion);
                sb.append('-');
                String os = "linux";
                if (OSDetector.isApple()) {
                    os = "darwin";
                }
                sb.append(os);
                sb.append("-x");
                String bitmode = OSDetector.getBitmode();
                if (bitmode.equals("32") || OSDetector.isWindows()) {
                    bitmode = "86";
                }
                sb.append(bitmode);
                sb.append(".tar.gz");
                return sb.toString();
            }
        };
        this._project = project;
    }

    public File getNodeDir() {
        return GradleUtil.toFile(this._project, this._nodeDir);
    }

    public String getNodeExeUrl() {
        return GradleUtil.toString((Object)this._nodeExeUrl);
    }

    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    public List<String> getNpmArgs() {
        return GradleUtil.toStringList(this._npmArgs);
    }

    public boolean isDownload() {
        return this._download;
    }

    public NodeExtension npmArgs(Iterable<?> npmArgs) {
        GUtil.addToCollection(this._npmArgs, (Iterable[])new Iterable[]{npmArgs});
        return this;
    }

    public NodeExtension npmArgs(Object ... npmArgs) {
        return this.npmArgs(Arrays.asList(npmArgs));
    }

    public void setDownload(boolean download) {
        this._download = download;
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setNodeExeUrl(Object nodeExeUrl) {
        this._nodeExeUrl = nodeExeUrl;
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }

    public void setNpmArgs(Iterable<?> npmArgs) {
        this._npmArgs.clear();
        this.npmArgs(npmArgs);
    }

    public void setNpmArgs(Object ... npmArgs) {
        this.setNpmArgs(Arrays.asList(npmArgs));
    }
}

