/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.GradleUtil;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;

public class NodePlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        this.addTaskDownloadNode(project);
        this.addTaskNpmInstall(project);
        this.configureTasksDownloadNode(project, nodeExtension);
        this.configureTasksExecuteNode(project, nodeExtension);
        this.configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this.configureTasksExecuteNpm(project, nodeExtension);
            }
        });
    }

    protected DownloadNodeTask addTaskDownloadNode(Project project) {
        return (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_NODE_TASK_NAME, DownloadNodeTask.class);
    }

    protected ExecuteNpmTask addTaskNpmInstall(Project project) {
        final ExecuteNpmTask executeNpmTask = (ExecuteNpmTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, ExecuteNpmTask.class);
        executeNpmTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                File packageJsonFile = project.file((Object)"package.json");
                if (!packageJsonFile.exists()) {
                    return false;
                }
                JsonSlurper jsonSlurper = new JsonSlurper();
                Map packageJson = (Map)jsonSlurper.parse(packageJsonFile);
                return packageJson.containsKey("dependencies") || packageJson.containsKey("devDependencies");
            }
        });
        executeNpmTask.setArgs("install");
        executeNpmTask.setDescription("Install Node packages from package.json.");
        TaskInputs taskInputs = executeNpmTask.getInputs();
        taskInputs.file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(executeNpmTask.getWorkingDir(), "package.json");
            }
        });
        TaskOutputsInternal taskOutputs = executeNpmTask.getOutputs();
        taskOutputs.dir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(executeNpmTask.getWorkingDir(), "node_modules");
            }
        });
        return executeNpmTask;
    }

    protected void configureTaskDownloadNode(DownloadNodeTask downloadNodeTask, final NodeExtension nodeExtension) {
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
        downloadNodeTask.setNodeExeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeExeUrl();
            }
        });
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
    }

    protected void configureTaskExecuteNode(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
    }

    protected void configureTaskExecuteNpm(ExecuteNpmTask executeNpmTask, NodeExtension nodeExtension) {
        executeNpmTask.args(nodeExtension.getNpmArgs());
    }

    protected void configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String moduleName = _osgiHelper.getBundleSymbolicName(project);
                int pos = moduleName.indexOf(46);
                if (pos != -1) {
                    moduleName = moduleName.substring(pos + 1);
                    moduleName = moduleName.replace('.', '-');
                }
                return moduleName;
            }
        });
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    protected void configureTasksDownloadNode(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeTask.class, (Action)new Action<DownloadNodeTask>(){

            public void execute(DownloadNodeTask downloadNodeTask) {
                NodePlugin.this.configureTaskDownloadNode(downloadNodeTask, nodeExtension);
            }
        });
    }

    protected void configureTasksExecuteNode(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this.configureTaskExecuteNode(executeNodeTask, nodeExtension);
            }
        });
    }

    protected void configureTasksExecuteNpm(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodePlugin.this.configureTaskExecuteNpm(executeNpmTask, nodeExtension);
            }
        });
    }

    protected void configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this.configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }
}

