/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.util.NodeExecutor;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class DownloadNodeTask
extends DefaultTask {
    private final NodeExecutor _nodeExecutor = new NodeExecutor(this.getProject());
    private Object _nodeExeUrl;
    private Object _nodeUrl;

    public DownloadNodeTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File nodeDir = DownloadNodeTask.this.getNodeDir();
                return nodeDir == null || !nodeDir.exists();
            }
        });
    }

    @TaskAction
    public void downloadNode() throws IOException {
        final File nodeDir = this.getNodeDir();
        final Project project = this.getProject();
        final File nodeFile = FileUtil.get((Project)project, (String)this.getNodeUrl());
        project.delete(new Object[]{nodeDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
                copySpec.from(new Object[]{project.tarTree((Object)nodeFile)});
                copySpec.into((Object)nodeDir);
                copySpec.setIncludeEmptyDirs(false);
            }
        });
        if (OSDetector.isWindows()) {
            File nodeBinDir = new File(this.getNodeDir(), "bin");
            FileUtil.get((Project)project, (String)this.getNodeExeUrl(), (File)nodeBinDir);
        }
    }

    @OutputDirectory
    public File getNodeDir() {
        return this._nodeExecutor.getNodeDir();
    }

    @Input
    public String getNodeExeUrl() {
        return GradleUtil.toString((Object)this._nodeExeUrl);
    }

    @Input
    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeExecutor.setNodeDir(nodeDir);
    }

    public void setNodeExeUrl(Object nodeExeUrl) {
        this._nodeExeUrl = nodeExeUrl;
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }
}

