/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.util;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.util.GUtil;

public class NodeExecutor {
    private static final String[] _PATH_KEYS = new String[]{"Path", "PATH"};
    private final List<Object> _args = new ArrayList<Object>();
    private Object _command = "node";
    private Object _nodeDir;
    private final Project _project;
    private Object _workingDir;

    public NodeExecutor(Project project) {
        this._project = project;
        this._workingDir = this._project.getProjectDir();
    }

    public NodeExecutor args(Iterable<?> args) {
        GUtil.addToCollection(this._args, (Iterable[])new Iterable[]{args});
        return this;
    }

    public NodeExecutor args(Object ... args) {
        return this.args(Arrays.asList(args));
    }

    public ExecResult execute() {
        return this._project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                if (OSDetector.isWindows()) {
                    execSpec.setArgs(NodeExecutor.this.getWindowsArgs());
                    execSpec.setExecutable((Object)"cmd");
                } else {
                    execSpec.setArgs((Iterable)NodeExecutor.this._args);
                    execSpec.setExecutable((Object)NodeExecutor.this.getExecutable());
                }
                execSpec.setEnvironment(NodeExecutor.this.getEnvironment());
                execSpec.setWorkingDir(NodeExecutor.this._workingDir);
            }
        });
    }

    public List<String> getArgs() {
        return GradleUtil.toStringList(this._args);
    }

    public String getCommand() {
        return GradleUtil.toString((Object)this._command);
    }

    public File getNodeDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._nodeDir);
    }

    public File getWorkingDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._workingDir);
    }

    public void setArgs(Iterable<?> args) {
        this._args.clear();
        this.args(args);
    }

    public void setArgs(Object ... args) {
        this.setArgs(Arrays.asList(args));
    }

    public void setCommand(Object command) {
        this._command = command;
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setWorkingDir(Object workingDir) {
        this._workingDir = workingDir;
    }

    protected Map<String, String> getEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        File executableDir = this.getExecutableDir();
        for (String pathKey : _PATH_KEYS) {
            String path = (String)environment.get(pathKey);
            if (Validator.isNull((String)path)) continue;
            path = executableDir.getAbsolutePath() + File.pathSeparator + path;
            environment.put(pathKey, path);
        }
        return environment;
    }

    protected File getExecutable() {
        return new File(this.getExecutableDir(), GradleUtil.toString((Object)this._command));
    }

    protected File getExecutableDir() {
        File executableDir = GradleUtil.toFile((Project)this._project, (Object)this._nodeDir);
        if (!OSDetector.isWindows()) {
            executableDir = new File(executableDir, "bin");
        }
        return executableDir;
    }

    protected List<String> getWindowsArgs() {
        ArrayList<String> windowsArgs = new ArrayList<String>(2);
        windowsArgs.add("/c");
        StringBuilder sb = new StringBuilder();
        sb.append("\"\"");
        sb.append(this.getExecutable());
        sb.append('\"');
        for (String arg : this.getArgs()) {
            sb.append(" \"");
            if (Validator.isNotNull((String)arg)) {
                sb.append(arg);
            }
            sb.append('\"');
        }
        sb.append('\"');
        windowsArgs.add(sb.toString());
        return windowsArgs;
    }
}

