/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.util.NodeExecutor;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;

public class DownloadNodeTask
extends DefaultTask {
    private final NodeExecutor _nodeExecutor = new NodeExecutor(this.getProject());
    private Object _nodeUrl;
    private Object _npmUrl;

    public DownloadNodeTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File nodeDir = DownloadNodeTask.this.getNodeDir();
                return nodeDir == null || !nodeDir.exists();
            }
        });
    }

    @TaskAction
    public void downloadNode() throws IOException {
        final File nodeDir = this.getNodeDir();
        String nodeUrl = this.getNodeUrl();
        final Project project = this.getProject();
        final File nodeFile = FileUtil.get((Project)project, (String)nodeUrl);
        if (nodeUrl.endsWith(".tar.gz")) {
            project.delete(new Object[]{nodeDir});
            project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    execSpec.args(new Object[]{"xfz", project.relativePath((Object)nodeFile)});
                    execSpec.args(new Object[]{"-C", project.relativePath((Object)nodeDir.getParentFile())});
                    execSpec.setExecutable((Object)"tar");
                }
            });
            String dirName = nodeFile.getName();
            dirName = dirName.substring(0, dirName.lastIndexOf(".tar.gz"));
            File dir = new File(nodeDir.getParentFile(), dirName);
            dir.renameTo(nodeDir);
        } else {
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{nodeFile});
                    copySpec.into((Object)nodeDir);
                }
            });
        }
        if (OSDetector.isWindows()) {
            final File npmFile = FileUtil.get((Project)project, (String)this.getNpmUrl());
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{project.zipTree((Object)npmFile)});
                    copySpec.into((Object)nodeDir);
                }
            });
        }
    }

    @OutputDirectory
    public File getNodeDir() {
        return this._nodeExecutor.getNodeDir();
    }

    @Input
    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    @Input
    public String getNpmUrl() {
        return GradleUtil.toString((Object)this._npmUrl);
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeExecutor.setNodeDir(nodeDir);
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }

    public void setNpmUrl(Object npmUrl) {
        this._npmUrl = npmUrl;
    }
}

