/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder;

import com.liferay.gradle.plugins.maven.plugin.builder.BuildPluginDescriptorTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;

public class MavenPluginBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_PLUGIN_DESCRIPTOR_TASK_NAME = "buildPluginDescriptor";
    public static final String MAVEN_EMBEDDER_CONFIGURATION_NAME = "mavenEmbedder";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration mavenEmbedderConfiguration = this.addConfigurationMavenEmbedder(project);
        BuildPluginDescriptorTask buildPluginDescriptorTask = this.addTaskBuildPluginDescriptor(project, (FileCollection)mavenEmbedderConfiguration);
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.isJava8Compatible()) {
            this.configureTasksJavadocDisableDoclint(project);
        }
        this.configureTasksUpload(project, buildPluginDescriptorTask);
    }

    protected Configuration addConfigurationMavenEmbedder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                MavenPluginBuilderPlugin.this.addDependenciesMavenEmbedder(project);
            }
        });
        configuration.setDescription("Configures Maven Embedder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesMavenEmbedder(Project project) {
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.apache.maven", (String)"maven-embedder", (String)"3.3.9");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.apache.maven.wagon", (String)"wagon-http", (String)"2.10");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.eclipse.aether", (String)"aether-connector-basic", (String)"1.0.2.v20150114");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.eclipse.aether", (String)"aether-transport-wagon", (String)"1.0.2.v20150114");
        GradleUtil.addDependency((Project)project, (String)MAVEN_EMBEDDER_CONFIGURATION_NAME, (String)"org.slf4j", (String)"slf4j-simple", (String)"1.7.5");
    }

    protected BuildPluginDescriptorTask addTaskBuildPluginDescriptor(final Project project, FileCollection mavenEmbedderClasspath) {
        BuildPluginDescriptorTask buildPluginDescriptorTask = (BuildPluginDescriptorTask)GradleUtil.addTask((Project)project, (String)BUILD_PLUGIN_DESCRIPTOR_TASK_NAME, BuildPluginDescriptorTask.class);
        buildPluginDescriptorTask.dependsOn(new Object[]{"compileJava"});
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        buildPluginDescriptorTask.setClassesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getClassesDir();
            }
        });
        buildPluginDescriptorTask.setDescription("Generates the Maven plugin descriptor for the project.");
        buildPluginDescriptorTask.setGroup("build");
        buildPluginDescriptorTask.setMavenEmbedderClasspath(mavenEmbedderClasspath);
        buildPluginDescriptorTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = MavenPluginBuilderPlugin.this.getSrcDir(sourceSet.getResources());
                return new File(resourcesDir, "META-INF/maven");
            }
        });
        buildPluginDescriptorTask.setPomArtifactId(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _osgiHelper.getBundleSymbolicName(project);
            }
        });
        buildPluginDescriptorTask.setPomGroupId(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getGroup();
            }
        });
        buildPluginDescriptorTask.setPomVersion(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String version = String.valueOf(project.getVersion());
                if (version.endsWith("-SNAPSHOT")) {
                    version = version.substring(0, version.length() - 9);
                }
                return version;
            }
        });
        buildPluginDescriptorTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return MavenPluginBuilderPlugin.this.getSrcDir(sourceSet.getJava());
            }
        });
        Task processResourcesTask = GradleUtil.getTask((Project)project, (String)"processResources");
        processResourcesTask.mustRunAfter(new Object[]{buildPluginDescriptorTask});
        return buildPluginDescriptorTask;
    }

    protected void configureTaskJavadocDisableDoclint(Javadoc javadoc) {
        CoreJavadocOptions coreJavadocOptions = (CoreJavadocOptions)javadoc.getOptions();
        coreJavadocOptions.addStringOption("Xdoclint:none", "-quiet");
    }

    protected void configureTasksJavadocDisableDoclint(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                MavenPluginBuilderPlugin.this.configureTaskJavadocDisableDoclint(javadoc);
            }
        });
    }

    protected void configureTasksUpload(Project project, final BuildPluginDescriptorTask buildPluginDescriptorTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Upload.class, (Action)new Action<Upload>(){

            public void execute(Upload upload) {
                MavenPluginBuilderPlugin.this.configureTaskUpload(upload, buildPluginDescriptorTask);
            }
        });
    }

    protected void configureTaskUpload(Upload upload, BuildPluginDescriptorTask buildPluginDescriptorTask) {
        upload.dependsOn(new Object[]{buildPluginDescriptorTask});
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

