/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.maven.plugin.builder;

import com.liferay.gradle.plugins.maven.plugin.builder.util.XMLUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.GUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuildPluginDescriptorTask
extends DefaultTask {
    private static final Logger _logger = Logging.getLogger(BuildPluginDescriptorTask.class);
    private Object _classesDir;
    private final Map<String, String> _configurationScopeMappings = new HashMap<String, String>();
    private final Set<String> _forcedExclusions = new HashSet<String>();
    private Object _goalPrefix;
    private FileCollection _mavenEmbedderClasspath;
    private Object _mavenEmbedderMainClassName = "org.apache.maven.cli.MavenCli";
    private Object _mavenPluginPluginVersion = "3.4";
    private Object _outputDir;
    private Object _pomArtifactId;
    private Object _pomGroupId;
    private final Map<String, Object> _pomRepositories = new LinkedHashMap<String, Object>();
    private Object _pomVersion;
    private Object _sourceDir;
    private boolean _useSetterComments = true;

    public BuildPluginDescriptorTask() {
        this._configurationScopeMappings.put("compile", "compile");
        this._configurationScopeMappings.put("provided", "provided");
        this._pomRepositories.put("liferay-public", "http://repository.liferay.com/nexus/content/groups/public");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void buildPluginDescriptor() {
        File pomFile;
        Project project;
        block6: {
            project = this.getProject();
            pomFile = project.file((Object)(System.currentTimeMillis() + ".xml"));
            File preparedSourceDir = null;
            try {
                if (this.isUseSetterComments()) {
                    preparedSourceDir = new File(this.getTemporaryDir(), "prepared-source");
                    this.prepareSources(preparedSourceDir);
                }
                this.buildPomFile(pomFile, preparedSourceDir);
                this.buildPluginDescriptor(pomFile);
                this.readdForcedExclusions();
                if (preparedSourceDir == null) break block6;
            }
            catch (Exception e) {
                try {
                    throw new GradleException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (preparedSourceDir != null) {
                        project.delete(new Object[]{preparedSourceDir});
                    }
                    project.delete(new Object[]{pomFile});
                    throw throwable;
                }
            }
            project.delete(new Object[]{preparedSourceDir});
        }
        project.delete(new Object[]{pomFile});
    }

    public void configurationScopeMapping(String configurationName, String scope) {
        this._configurationScopeMappings.put(configurationName, scope);
    }

    public BuildPluginDescriptorTask forcedExclusions(Iterable<String> forcedExclusions) {
        GUtil.addToCollection(this._forcedExclusions, (Iterable[])new Iterable[]{forcedExclusions});
        return this;
    }

    public BuildPluginDescriptorTask forcedExclusions(String ... forcedExclusions) {
        return this.forcedExclusions(Arrays.asList(forcedExclusions));
    }

    @InputDirectory
    public File getClassesDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._classesDir);
    }

    public Map<String, String> getConfigurationScopeMappings() {
        return this._configurationScopeMappings;
    }

    @Input
    public Set<String> getForcedExclusions() {
        return this._forcedExclusions;
    }

    @Input
    public String getGoalPrefix() {
        return GradleUtil.toString((Object)this._goalPrefix);
    }

    @InputFiles
    public FileCollection getMavenEmbedderClasspath() {
        return this._mavenEmbedderClasspath;
    }

    @Input
    public String getMavenEmbedderMainClassName() {
        return GradleUtil.toString((Object)this._mavenEmbedderMainClassName);
    }

    @Input
    public String getMavenPluginPluginVersion() {
        return GradleUtil.toString((Object)this._mavenPluginPluginVersion);
    }

    @OutputDirectory
    public File getOutputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputDir);
    }

    @Input
    public String getPomArtifactId() {
        return GradleUtil.toString((Object)this._pomArtifactId);
    }

    @Input
    public String getPomGroupId() {
        return GradleUtil.toString((Object)this._pomGroupId);
    }

    @Input
    public Map<String, Object> getPomRepositories() {
        return this._pomRepositories;
    }

    @Input
    public String getPomVersion() {
        return GradleUtil.toString((Object)this._pomVersion);
    }

    @InputDirectory
    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @Input
    public boolean isUseSetterComments() {
        return this._useSetterComments;
    }

    public BuildPluginDescriptorTask pomRepositories(Map<String, ?> pomRepositories) {
        this._pomRepositories.putAll(pomRepositories);
        return this;
    }

    public BuildPluginDescriptorTask pomRepository(String id, Object url) {
        this._pomRepositories.put(id, url);
        return this;
    }

    public void setClassesDir(Object classesDir) {
        this._classesDir = classesDir;
    }

    public void setForcedExclusions(Iterable<String> forcedExclusions) {
        this._forcedExclusions.clear();
        this.forcedExclusions(forcedExclusions);
    }

    public void setForcedExclusions(String ... forcedExclusions) {
        this.setForcedExclusions(Arrays.asList(forcedExclusions));
    }

    public void setGoalPrefix(Object goalPrefix) {
        this._goalPrefix = goalPrefix;
    }

    public void setMavenEmbedderClasspath(FileCollection mavenEmbedderClasspath) {
        this._mavenEmbedderClasspath = mavenEmbedderClasspath;
    }

    public void setMavenEmbedderMainClassName(Object mavenEmbedderMainClassName) {
        this._mavenEmbedderMainClassName = mavenEmbedderMainClassName;
    }

    public void setMavenPluginPluginVersion(Object mavenPluginPluginVersion) {
        this._mavenPluginPluginVersion = mavenPluginPluginVersion;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setPomArtifactId(Object pomArtifactId) {
        this._pomArtifactId = pomArtifactId;
    }

    public void setPomGroupId(Object pomGroupId) {
        this._pomGroupId = pomGroupId;
    }

    public void setPomRepositories(Map<String, ?> pomRepositories) {
        this._pomRepositories.clear();
        this.pomRepositories(pomRepositories);
    }

    public void setPomVersion(Object pomVersion) {
        this._pomVersion = pomVersion;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setUseSetterComments(boolean useSetterComments) {
        this._useSetterComments = useSetterComments;
    }

    protected void appendDependencyElements(Document document, Element dependenciesElement, String configurationName, String scope) {
        Project project = this.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.findByName(configurationName);
        if (configuration == null) {
            return;
        }
        Set<String> forcedExclusions = this.getForcedExclusions();
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        for (Dependency dependency : configuration.getDependencies()) {
            Element dependencyElement = document.createElement("dependency");
            dependenciesElement.appendChild(dependencyElement);
            final String dependencyGroup = dependency.getGroup();
            final String dependencyName = dependency.getName();
            XMLUtil.appendElement(document, dependencyElement, "groupId", dependencyGroup);
            XMLUtil.appendElement(document, dependencyElement, "artifactId", dependencyName);
            String dependencyVersion = dependency.getVersion();
            Set resolvedDependencies = resolvedConfiguration.getFirstLevelModuleDependencies((Spec)new Spec<Dependency>(){

                public boolean isSatisfiedBy(Dependency dependency) {
                    return dependencyGroup.equals(dependency.getGroup()) && dependencyName.equals(dependency.getName());
                }
            });
            if (!resolvedDependencies.isEmpty()) {
                Iterator iterator = resolvedDependencies.iterator();
                ResolvedDependency resolvedDependency = (ResolvedDependency)iterator.next();
                dependencyVersion = resolvedDependency.getModuleVersion();
            } else if (_logger.isWarnEnabled()) {
                _logger.warn("Unable to find resolved module version for " + dependency);
            }
            XMLUtil.appendElement(document, dependencyElement, "version", dependencyVersion);
            XMLUtil.appendElement(document, dependencyElement, "scope", scope);
            if (forcedExclusions.isEmpty()) continue;
            Element exclusionsElement = document.createElement("exclusions");
            dependencyElement.appendChild(exclusionsElement);
            for (String dependencyNotation : forcedExclusions) {
                this.appendDependencyExclusionElement(document, exclusionsElement, dependencyNotation);
            }
        }
    }

    protected void appendDependencyExclusionElement(Document document, Element exclusionsElement, String dependencyNotation) {
        String[] tokens = this.parseDependencyNotation(dependencyNotation);
        String groupId = tokens[0];
        String artifactId = tokens[1];
        this.appendDependencyExclusionElement(document, exclusionsElement, groupId, artifactId);
    }

    protected void appendDependencyExclusionElement(Document document, Element exclusionsElement, String groupId, String artifactId) {
        Element exclusionElement = document.createElement("exclusion");
        exclusionsElement.appendChild(exclusionElement);
        XMLUtil.appendElement(document, exclusionElement, "artifactId", artifactId);
        XMLUtil.appendElement(document, exclusionElement, "groupId", groupId);
    }

    protected void appendRepositoryElement(Document document, Element repositoriesElement, String id, String url) {
        Element repositoryElement = document.createElement("repository");
        repositoriesElement.appendChild(repositoryElement);
        XMLUtil.appendElement(document, repositoryElement, "id", id);
        XMLUtil.appendElement(document, repositoryElement, "url", url);
    }

    protected void buildPluginDescriptor(final File pomFile) throws Exception {
        final Project project = this.getProject();
        project.javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.args(new Object[]{"-B"});
                javaExecSpec.args(new Object[]{"-e"});
                javaExecSpec.args(new Object[]{"-f"});
                javaExecSpec.args(new Object[]{project.relativePath((Object)pomFile)});
                javaExecSpec.args(new Object[]{"-Dencoding=UTF-8"});
                javaExecSpec.args(new Object[]{"plugin:descriptor"});
                javaExecSpec.setClasspath(BuildPluginDescriptorTask.this.getMavenEmbedderClasspath());
                javaExecSpec.setMain(BuildPluginDescriptorTask.this.getMavenEmbedderMainClassName());
                javaExecSpec.systemProperty("maven.multiModuleProjectDirectory", (Object)project.getProjectDir());
            }
        });
        File dir = new File(this.getClassesDir(), "META-INF/maven");
        File outputDir = this.getOutputDir();
        project.delete(new Object[]{outputDir});
        Files.move(dir.toPath(), outputDir.toPath(), new CopyOption[0]);
    }

    protected void buildPomFile(File pomFile, File sourceDir) throws Exception {
        Project project = this.getProject();
        if (sourceDir == null) {
            sourceDir = this.getSourceDir();
        }
        Document document = XMLUtil.createDocument();
        Element projectElement = document.createElementNS("http://maven.apache.org/POM/4.0.0", "project");
        document.appendChild(projectElement);
        XMLUtil.appendElement(document, projectElement, "modelVersion", "4.0.0");
        XMLUtil.appendElement(document, projectElement, "groupId", this.getPomGroupId());
        XMLUtil.appendElement(document, projectElement, "artifactId", this.getPomArtifactId());
        XMLUtil.appendElement(document, projectElement, "version", this.getPomVersion());
        XMLUtil.appendElement(document, projectElement, "packaging", "maven-plugin");
        Element buildElement = document.createElement("build");
        projectElement.appendChild(buildElement);
        XMLUtil.appendElement(document, buildElement, "outputDirectory", project.relativePath((Object)this.getClassesDir()));
        XMLUtil.appendElement(document, buildElement, "sourceDirectory", project.relativePath((Object)sourceDir));
        Element pluginsElement = document.createElement("plugins");
        buildElement.appendChild(pluginsElement);
        Element pluginElement = document.createElement("plugin");
        pluginsElement.appendChild(pluginElement);
        XMLUtil.appendElement(document, pluginElement, "groupId", "org.apache.maven.plugins");
        XMLUtil.appendElement(document, pluginElement, "artifactId", "maven-plugin-plugin");
        XMLUtil.appendElement(document, pluginElement, "version", this.getMavenPluginPluginVersion());
        String goalPrefix = this.getGoalPrefix();
        if (Validator.isNotNull((String)goalPrefix)) {
            Element configurationElement = document.createElement("configuration");
            pluginElement.appendChild(configurationElement);
            XMLUtil.appendElement(document, configurationElement, "goalPrefix", goalPrefix);
        }
        Element dependenciesElement = document.createElement("dependencies");
        projectElement.appendChild(dependenciesElement);
        Map<String, String> pomConfigurationScopeMappings = this.getConfigurationScopeMappings();
        for (Map.Entry<String, String> entry : pomConfigurationScopeMappings.entrySet()) {
            String configurationName = entry.getKey();
            String scope = entry.getValue();
            this.appendDependencyElements(document, dependenciesElement, configurationName, scope);
        }
        Map<String, Object> pomRepositories = this.getPomRepositories();
        if (!pomRepositories.isEmpty()) {
            Element repositoriesElement = document.createElement("repositories");
            projectElement.appendChild(repositoriesElement);
            for (Map.Entry<String, Object> entry : pomRepositories.entrySet()) {
                String id = entry.getKey();
                String url = GradleUtil.toString((Object)entry.getValue());
                this.appendRepositoryElement(document, repositoriesElement, id, url);
            }
        }
        XMLUtil.write(document, pomFile);
    }

    protected String getComments(JavaMethod javaMethod) {
        String code = javaMethod.getCodeBlock();
        int start = code.indexOf("/**");
        if (start < 0) {
            throw new GradleException("Unable to find comments start " + code);
        }
        int end = code.indexOf("*/", start);
        if (end < 0) {
            throw new GradleException("Unable to find comments end " + code);
        }
        return code.substring(start, end + 2);
    }

    protected String[] parseDependencyNotation(String dependencyNotation) {
        String[] tokens = dependencyNotation.split(":");
        if (tokens.length != 3) {
            throw new GradleException("Unable to parse dependency notation " + dependencyNotation);
        }
        return tokens;
    }

    protected void prepareSource(JavaClass javaClass) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (BeanProperty beanProperty : javaClass.getBeanProperties()) {
            JavaMethod javaMethod = beanProperty.getMutator();
            DocletTag parameterDocletTag = javaMethod.getTagByName("parameter");
            if (parameterDocletTag == null) continue;
            sb.append(this.getComments(javaMethod));
            sb.append('\n');
            sb.append("private ");
            Type type = beanProperty.getType();
            sb.append(type.getFullyQualifiedName());
            sb.append(' ');
            sb.append(beanProperty.getName());
            sb.append(';');
            sb.append('\n');
        }
        if (sb.length() == 0) {
            return;
        }
        JavaSource javaSource = javaClass.getSource();
        String code = javaSource.getCodeBlock();
        int pos = code.lastIndexOf(125);
        code = code.substring(0, pos) + sb.toString() + code.substring(pos);
        URL url = javaSource.getURL();
        Files.write(Paths.get(url.toURI()), code.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    protected void prepareSources(final File preparedSourceDir) throws Exception {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{BuildPluginDescriptorTask.this.getSourceDir()});
                copySpec.include(new String[]{"**/*Mojo.java"});
                copySpec.into((Object)preparedSourceDir);
            }
        });
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        javaDocBuilder.addSourceTree(preparedSourceDir);
        for (JavaClass javaClass : javaDocBuilder.getClasses()) {
            this.prepareSource(javaClass);
        }
    }

    protected void readdForcedExclusions() throws Exception {
        Set<String> forcedExclusions = this.getForcedExclusions();
        if (forcedExclusions.isEmpty()) {
            return;
        }
        File file = new File(this.getOutputDir(), "plugin.xml");
        Path path = file.toPath();
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        int pos = content.lastIndexOf("</dependencies>");
        if (pos == -1) {
            if (_logger.isWarnEnabled()) {
                _logger.warn("Unable to readd forced exclusions");
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(content, 0, pos - 1);
        for (String dependencyNotation : forcedExclusions) {
            String[] tokens = this.parseDependencyNotation(dependencyNotation);
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            sb.append("<dependency>");
            sb.append("<groupId>");
            sb.append(groupId);
            sb.append("</groupId>");
            sb.append("<artifactId>");
            sb.append(artifactId);
            sb.append("</artifactId>");
            sb.append("<type>jar</type>");
            sb.append("<version>");
            sb.append(version);
            sb.append("</version>");
            sb.append("</dependency>");
        }
        sb.append(content, pos, content.length());
        content = sb.toString();
        Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

