/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.merger;

import com.liferay.gradle.plugins.lang.merger.tasks.MergePropertiesTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;

public class LangMergerPlugin
implements Plugin<Project> {
    public static final String MERGE_LANG_TASK_NAME = "mergeLang";
    private static final Logger _logger = Logging.getLogger(LangMergerPlugin.class);

    public void apply(Project project) {
        this.addTaskMergeLang(project);
    }

    protected MergePropertiesTask addTaskMergeLang(Project project) {
        final MergePropertiesTask mergePropertiesTask = (MergePropertiesTask)GradleUtil.addTask((Project)project, (String)MERGE_LANG_TASK_NAME, MergePropertiesTask.class);
        mergePropertiesTask.setDescription("Merges language property files.");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LangMergerPlugin.this.configureTaskMergeLangForJavaPlugin(mergePropertiesTask);
            }
        });
        return mergePropertiesTask;
    }

    protected void configureTaskMergeLangForJavaPlugin(MergePropertiesTask mergePropertiesTask) {
        mergePropertiesTask.mustRunAfter(new Object[]{"processResources"});
        final Project project = mergePropertiesTask.getProject();
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        mergePropertiesTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File(sourceSetOutput.getResourcesDir(), "content");
            }
        });
        final Project langProject = this.getLangProject(project);
        if (langProject != null) {
            if (_logger.isInfoEnabled()) {
                _logger.info("Using " + langProject + " as merge source");
            }
            mergePropertiesTask.setSourceDirs(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    File contentDir = LangMergerPlugin.this.getContentDir(sourceSet);
                    return langProject.file((Object)project.relativePath((Object)contentDir));
                }
            }, new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return LangMergerPlugin.this.getContentDir(sourceSet);
                }
            });
        } else if (_logger.isInfoEnabled()) {
            _logger.info("Unable to find a language project to use as merge source");
        }
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{mergePropertiesTask});
    }

    protected File getContentDir(SourceSet sourceSet) {
        File resourcesDir = this.getSrcDir(sourceSet.getResources());
        return new File(resourcesDir, "content");
    }

    protected Project getLangProject(Project project) {
        int index;
        Project langProject;
        Project parentProject = project.getParent();
        if (parentProject == null) {
            return null;
        }
        String langProjectPath = parentProject.getPath() + ":" + parentProject.getName() + "-lang";
        if (_logger.isDebugEnabled()) {
            _logger.debug("Looking for " + langProjectPath);
        }
        if ((langProject = project.findProject(langProjectPath)) == null && (index = langProjectPath.indexOf(58, 1)) != -1) {
            langProjectPath = langProjectPath.substring(index);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Looking for " + langProjectPath);
            }
            langProject = project.findProject(langProjectPath);
        }
        return langProject;
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

