/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.merger.tasks;

import com.liferay.gradle.plugins.lang.merger.tasks.BaseMergeTask;
import com.liferay.gradle.plugins.lang.merger.tasks.MergePropertiesSetting;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;

public class MergePropertiesTask
extends BaseMergeTask {
    private static final String _PATTERN = "*.properties";
    private Object _charsetName = StandardCharsets.UTF_8.name();
    private final NamedDomainObjectContainer<MergePropertiesSetting> _mergePropertiesSettings;

    public MergePropertiesTask() {
        Project project = this.getProject();
        this._mergePropertiesSettings = project.container(MergePropertiesSetting.class);
    }

    @Input
    public String getCharsetName() {
        return GradleUtil.toString((Object)this._charsetName);
    }

    @Override
    public String getPattern() {
        return _PATTERN;
    }

    public NamedDomainObjectContainer<MergePropertiesSetting> getSettings() {
        return this._mergePropertiesSettings;
    }

    public void setCharsetName(Object charsetName) {
        this._charsetName = charsetName;
    }

    public MergePropertiesSetting setting(Object object, Closure<Void> closure) throws IOException {
        File dir = GradleUtil.toFile((Project)this.getProject(), (Object)object);
        return (MergePropertiesSetting)this._mergePropertiesSettings.create(this._getSettingName(dir), closure);
    }

    @Override
    protected boolean isCopyAllowed() {
        return this._mergePropertiesSettings.isEmpty();
    }

    @Override
    protected void merge(Set<File> sourceFiles, File destinationFile) throws IOException {
        Charset charset = Charset.forName(this.getCharsetName());
        Properties mergedProperties = new Properties();
        for (File sourceFile : sourceFiles) {
            if (!sourceFile.exists()) continue;
            Properties sourceProperties = new Properties();
            try (BufferedReader bufferedReader = Files.newBufferedReader(sourceFile.toPath(), charset);){
                sourceProperties.load(bufferedReader);
            }
            MergePropertiesSetting mergePropertiesSetting = (MergePropertiesSetting)this._mergePropertiesSettings.findByName(this._getSettingName(sourceFile));
            if (mergePropertiesSetting != null) {
                Map<String, String> transformKeys = mergePropertiesSetting.getTransformKeys();
                for (Map.Entry<String, String> entry : transformKeys.entrySet()) {
                    String sourceKey = entry.getKey();
                    String destinationKey = entry.getValue();
                    String value = sourceProperties.getProperty(sourceKey);
                    mergedProperties.setProperty(destinationKey, value);
                }
                continue;
            }
            mergedProperties.putAll((Map<?, ?>)sourceProperties);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(destinationFile.toPath(), charset, new OpenOption[0]);){
            mergedProperties.store(bufferedWriter, null);
        }
    }

    private String _getSettingName(File file) throws IOException {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        String name = file.getCanonicalPath();
        if (File.separatorChar != '/') {
            name = name.replace(File.separatorChar, '/');
        }
        return name;
    }
}

