/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.merger.tasks;

import com.liferay.gradle.plugins.lang.merger.tasks.BaseMergeTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.tasks.Input;

public class MergePropertiesTask
extends BaseMergeTask {
    private static final String _PATTERN = "*.properties";
    private Object _charsetName = StandardCharsets.UTF_8.name();

    @Input
    public String getCharsetName() {
        return GradleUtil.toString((Object)this._charsetName);
    }

    @Override
    public String getPattern() {
        return _PATTERN;
    }

    public void setCharsetName(Object charsetName) {
        this._charsetName = charsetName;
    }

    @Override
    protected void merge(Set<File> sourceFiles, File destinationFile) throws IOException {
        Charset charset = Charset.forName(this.getCharsetName());
        Properties mergedProperties = new Properties();
        for (File sourceFile : sourceFiles) {
            if (!sourceFile.exists()) continue;
            Properties sourceProperties = new Properties();
            try (BufferedReader bufferedReader = Files.newBufferedReader(sourceFile.toPath(), charset);){
                sourceProperties.load(bufferedReader);
            }
            mergedProperties.putAll((Map<?, ?>)sourceProperties);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(destinationFile.toPath(), charset, new OpenOption[0]);){
            mergedProperties.store(bufferedWriter, null);
        }
    }
}

