/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.merger.tasks;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public abstract class BaseMergeTask
extends DefaultTask {
    private static final Logger _logger = Logging.getLogger(BaseMergeTask.class);
    private Object _destinationDir;
    private final Set<Object> _sourceDirs = new LinkedHashSet<Object>();

    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @OutputFiles
    public FileCollection getDestinationFiles() {
        HashSet<File> destinationFiles = new HashSet<File>();
        File destinationDir = this.getDestinationDir();
        Project project = this.getProject();
        for (File sourceDir : this.getSourceDirs()) {
            for (File sourceFile : this.getSourceFiles(sourceDir)) {
                String fileName = FileUtil.relativize((File)sourceFile, (File)sourceDir);
                File destinationFile = new File(destinationDir, fileName);
                destinationFiles.add(destinationFile);
            }
        }
        return project.files(new Object[]{destinationFiles});
    }

    public abstract String getPattern();

    public FileCollection getSourceDirs() {
        Project project = this.getProject();
        return project.files(new Object[]{this._sourceDirs});
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSourceFiles() {
        ArrayList<FileCollection> fileCollections = new ArrayList<FileCollection>();
        Project project = this.getProject();
        for (File sourceDir : this.getSourceDirs()) {
            FileCollection fileCollection = this.getSourceFiles(sourceDir);
            fileCollections.add(fileCollection);
        }
        return project.files(fileCollections.toArray());
    }

    @TaskAction
    public void merge() throws IOException {
        File destinationDir = this.getDestinationDir();
        FileCollection sourceDirs = this.getSourceDirs();
        for (File destinationFile : this.getDestinationFiles()) {
            File sourceFile;
            LinkedHashSet<File> sourceFiles = new LinkedHashSet<File>();
            String fileName = FileUtil.relativize((File)destinationFile, (File)destinationDir);
            for (File sourceDir : sourceDirs) {
                sourceFile = new File(sourceDir, fileName);
                if (!sourceFile.exists()) continue;
                sourceFiles.add(sourceFile);
            }
            File destinationFileDir = destinationFile.getParentFile();
            destinationFileDir.mkdirs();
            if (sourceFiles.size() == 1) {
                Iterator iterator = sourceFiles.iterator();
                sourceFile = (File)iterator.next();
                Files.copy(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (!_logger.isInfoEnabled()) continue;
                _logger.info("Copied " + sourceFile + " into " + destinationFile);
                continue;
            }
            this.merge(sourceFiles, destinationFile);
            if (!_logger.isInfoEnabled()) continue;
            _logger.info("Merged " + CollectionUtils.join((String)", ", sourceFiles) + " into " + destinationFile);
        }
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setSourceDirs(Iterable<Object> sourceDirs) {
        this._sourceDirs.clear();
        this.sourceDirs(sourceDirs);
    }

    public void setSourceDirs(Object ... sourceDirs) {
        this.setSourceDirs(Arrays.asList(sourceDirs));
    }

    public BaseMergeTask sourceDirs(Iterable<Object> sourceDirs) {
        GUtil.addToCollection(this._sourceDirs, (Iterable[])new Iterable[]{sourceDirs});
        return this;
    }

    public BaseMergeTask sourceDirs(Object ... sourceDirs) {
        return this.sourceDirs(Arrays.asList(sourceDirs));
    }

    protected FileCollection getSourceFiles(File sourceDir) {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", sourceDir);
        args.put("include", this.getPattern());
        return project.fileTree(args);
    }

    protected abstract void merge(Set<File> var1, File var2) throws IOException;
}

