/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.builder;

import com.liferay.gradle.plugins.lang.builder.internal.util.StringUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.lang.builder.LangBuilderArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class BuildLangTask
extends JavaExec {
    private final Set<Object> _excludedLanguageIds = new LinkedHashSet<Object>();
    private Object _langDir;
    private Object _langFileName = "Language";
    private boolean _titleCapitalization = true;
    private boolean _translate = true;
    private Object _translateSubscriptionKey;

    public BuildLangTask() {
        this.setExcludedLanguageIds(LangBuilderArgs.EXCLUDED_LANGUAGE_IDS);
        this.setMain("com.liferay.lang.builder.LangBuilder");
    }

    public BuildLangTask excludedLanguageIds(Iterable<?> excludedLanguageIds) {
        GUtil.addToCollection(this._excludedLanguageIds, excludedLanguageIds);
        return this;
    }

    public BuildLangTask excludedLanguageIds(Object ... excludedLanguageIds) {
        return this.excludedLanguageIds(Arrays.asList(excludedLanguageIds));
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @Input
    public Set<?> getExcludedLanguageIds() {
        return this._excludedLanguageIds;
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getLangDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._langDir);
    }

    @Input
    public String getLangFileName() {
        return GradleUtil.toString((Object)this._langFileName);
    }

    @Input
    @Optional
    public String getTranslateSubscriptionKey() {
        return GradleUtil.toString((Object)this._translateSubscriptionKey);
    }

    @Input
    public boolean isTitleCapitalization() {
        return this._titleCapitalization;
    }

    @Input
    public boolean isTranslate() {
        return this._translate;
    }

    public void setExcludedLanguageIds(Iterable<?> excludedLanguageIds) {
        this._excludedLanguageIds.clear();
        this.excludedLanguageIds(excludedLanguageIds);
    }

    public void setExcludedLanguageIds(Object ... excludedLanguageIds) {
        this.setExcludedLanguageIds(Arrays.asList(excludedLanguageIds));
    }

    public void setLangDir(Object langDir) {
        this._langDir = langDir;
    }

    public void setLangFileName(Object langFileName) {
        this._langFileName = langFileName;
    }

    public void setTitleCapitalization(boolean titleCapitalization) {
        this._titleCapitalization = titleCapitalization;
    }

    public void setTranslate(boolean translate) {
        this._translate = translate;
    }

    public void setTranslateSubscriptionKey(Object translateSubscriptionKey) {
        this._translateSubscriptionKey = translateSubscriptionKey;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("lang.dir=" + FileUtil.relativize((File)this.getLangDir(), (File)this.getWorkingDir()));
        args.add("lang.excluded.language.ids=" + StringUtil.merge(this.getExcludedLanguageIds(), ","));
        args.add("lang.file=" + this.getLangFileName());
        args.add("lang.title.capitalization=" + this.isTitleCapitalization());
        args.add("lang.translate=" + this.isTranslate());
        String translateSubscriptionKey = this.getTranslateSubscriptionKey();
        if (Validator.isNotNull((String)translateSubscriptionKey)) {
            args.add("lang.translate.subscription.key=" + translateSubscriptionKey);
        }
        return args;
    }
}

