/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.builder;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;

public class BuildLangTask
extends JavaExec {
    private Object _langDir;
    private Object _langFileName = "Language";
    private boolean _plugin = true;
    private Object _portalLanguagePropertiesFile;
    private boolean _translate = true;
    private Object _translateClientId;
    private Object _translateClientSecret;

    public BuildLangTask() {
        this.setMain("com.liferay.lang.builder.LangBuilder");
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    public File getLangDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._langDir);
    }

    @Input
    public String getLangFileName() {
        return GradleUtil.toString((Object)this._langFileName);
    }

    @InputFile
    @Optional
    public File getPortalLanguagePropertiesFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._portalLanguagePropertiesFile);
    }

    @Input
    public String getTranslateClientId() {
        return GradleUtil.toString((Object)this._translateClientId);
    }

    @Input
    public String getTranslateClientSecret() {
        return GradleUtil.toString((Object)this._translateClientSecret);
    }

    @Input
    public boolean isPlugin() {
        return this._plugin;
    }

    @Input
    public boolean isTranslate() {
        return this._translate;
    }

    public void setLangDir(Object langDir) {
        this._langDir = langDir;
    }

    public void setLangFileName(Object langFileName) {
        this._langFileName = langFileName;
    }

    public void setPlugin(boolean plugin) {
        this._plugin = plugin;
    }

    public void setPortalLanguagePropertiesFile(Object portalLanguagePropertiesFile) {
        this._portalLanguagePropertiesFile = portalLanguagePropertiesFile;
    }

    public void setTranslate(boolean translate) {
        this._translate = translate;
    }

    public void setTranslateClientId(Object translateClientId) {
        this._translateClientId = translateClientId;
    }

    public void setTranslateClientSecret(Object translateClientSecret) {
        this._translateClientSecret = translateClientSecret;
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("lang.dir=" + FileUtil.relativize((File)this.getLangDir(), (File)this.getWorkingDir()));
        args.add("lang.file=" + this.getLangFileName());
        args.add("lang.plugin=" + this.isPlugin());
        File portalLanguagePropertiesFile = this.getPortalLanguagePropertiesFile();
        if (portalLanguagePropertiesFile != null) {
            args.add("lang.portal.language.properties.file=" + FileUtil.relativize((File)this.getPortalLanguagePropertiesFile(), (File)this.getWorkingDir()));
        }
        args.add("lang.translate=" + this.isTranslate());
        args.add("lang.translate.client.id=" + this.getTranslateClientId());
        args.add("lang.translate.client.secret=" + this.getTranslateClientSecret());
        return args;
    }
}

