/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jsdoc;

import com.liferay.gradle.plugins.jsdoc.BaseJSDocPlugin;
import com.liferay.gradle.plugins.jsdoc.JSDocTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;

public class JSDocPlugin
extends BaseJSDocPlugin {
    public static final String JSDOC_TASK_NAME = "jsdoc";

    @Override
    public void apply(Project project) {
        super.apply(project);
        this._addTaskJSDoc(project);
    }

    private JSDocTask _addTaskJSDoc(Project project) {
        final JSDocTask jsDocTask = (JSDocTask)GradleUtil.addTask((Project)project, (String)JSDOC_TASK_NAME, JSDocTask.class);
        jsDocTask.setDescription("Generates the API documentation for the JavaScript code in this project.");
        jsDocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = jsDocTask.getProject();
                return new File(project.getBuildDir(), JSDocPlugin.JSDOC_TASK_NAME);
            }
        });
        jsDocTask.setGroup("documentation");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JSDocPlugin.this._configureTaskJSDocForJavaPlugin(jsDocTask);
            }
        });
        return jsDocTask;
    }

    private void _configureTaskJSDocForJavaPlugin(JSDocTask jsDocTask) {
        final Project project = jsDocTask.getProject();
        jsDocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
                return new File(javaPluginConvention.getDocsDir(), JSDocPlugin.JSDOC_TASK_NAME);
            }
        });
        jsDocTask.setSourceDirs(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(JSDocPlugin.this._getResourcesDir(project), "META-INF/resources");
            }
        });
    }

    private File _getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getResources());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

