/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jsdoc;

import com.liferay.gradle.plugins.jsdoc.AppJSDocConfigurationExtension;
import com.liferay.gradle.plugins.jsdoc.BaseJSDocPlugin;
import com.liferay.gradle.plugins.jsdoc.JSDocPlugin;
import com.liferay.gradle.plugins.jsdoc.JSDocTask;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.bundling.Jar;

public class AppJSDocPlugin
extends BaseJSDocPlugin {
    public static final String APP_JSDOC_TASK_NAME = "appJSDoc";
    public static final String JAR_APP_JSDOC_TASK_NAME = "jarAppJSDoc";
    public static final String PLUGIN_NAME = "appJSDocConfiguration";

    @Override
    public void apply(Project project) {
        super.apply(project);
        final AppJSDocConfigurationExtension appJSDocConfigurationExtension = (AppJSDocConfigurationExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, AppJSDocConfigurationExtension.class);
        final JSDocTask appJSDocTask = this._addTaskAppJSDoc(project);
        this._addTaskJarAppJSDoc(appJSDocTask);
        Gradle gradle = project.getGradle();
        gradle.afterProject((Closure)new Closure<Void>((Object)project){

            public void doCall(Project subproject) {
                Set<Project> subprojects = appJSDocConfigurationExtension.getSubprojects();
                PluginContainer pluginContainer = subproject.getPlugins();
                if (subprojects.contains(subproject) && pluginContainer.hasPlugin(JSDocPlugin.class)) {
                    AppJSDocPlugin.this._configureTaskAppJSDoc(appJSDocTask, subproject);
                }
            }
        });
    }

    private JSDocTask _addTaskAppJSDoc(Project project) {
        final JSDocTask appJSDocTask = (JSDocTask)GradleUtil.addTask((Project)project, (String)APP_JSDOC_TASK_NAME, JSDocTask.class);
        appJSDocTask.setDescription("Generates the API documentation for the JavaScript code in this app.");
        appJSDocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = appJSDocTask.getProject();
                return new File(project.getBuildDir(), "docs/jsdoc");
            }
        });
        appJSDocTask.setGroup("documentation");
        return appJSDocTask;
    }

    private Jar _addTaskJarAppJSDoc(JSDocTask jsDocTask) {
        Jar jar = (Jar)GradleUtil.addTask((Project)jsDocTask.getProject(), (String)JAR_APP_JSDOC_TASK_NAME, Jar.class);
        jar.from(new Object[]{jsDocTask});
        jar.setClassifier("jsdoc");
        jar.setDescription("Assembles a jar archive containing the JavaScript documentation files for this app.");
        jar.setGroup("build");
        return jar;
    }

    private void _configureTaskAppJSDoc(JSDocTask appJSDocTask, Project subproject) {
        JSDocTask subprojectJSDocTask = (JSDocTask)GradleUtil.getTask((Project)subproject, (String)"jsdoc");
        for (File dir : subprojectJSDocTask.getSourceDirs()) {
            if (!dir.exists()) continue;
            appJSDocTask.sourceDirs(dir);
        }
    }
}

