/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.transpiler;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.util.GUtil;

public class TranspileJSTask
extends ExecuteNodeScriptTask {
    private Object _bundleFileName = "";
    private Object _globalName = "";
    private Object _moduleName = "";
    private Object _modules = "amd";
    private Object _sourceDir;
    private SourceMaps _sourceMaps = SourceMaps.ENABLED;
    private boolean _soySkipMetalGeneration;
    private final Set<Object> _soySrcIncludes = new LinkedHashSet<Object>();
    private final Set<Object> _srcIncludes = new LinkedHashSet<Object>();

    public TranspileJSTask() {
        this.dependsOn(new Object[]{"downloadLfrAmdLoader"});
        this.dependsOn(new Object[]{"downloadMetalCli"});
        this.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(TranspileJSTask.this.getNodeDir(), "node_modules/metal-cli/index.js");
            }
        });
        this.soySrcInclude("**/*.soy");
        this.srcInclude("**/*.es.js", "**/*.soy.js");
    }

    public void executeNode() {
        File workingDir;
        final File sourceDir = this.getSourceDir();
        if (!sourceDir.equals(workingDir = this.getWorkingDir())) {
            Project project = this.getProject();
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{sourceDir});
                    copySpec.include(TranspileJSTask.this.getSoySrcIncludes());
                    copySpec.include(TranspileJSTask.this.getSrcIncludes());
                    copySpec.into((Object)workingDir);
                }
            });
        }
        super.executeNode();
    }

    @Input
    public String getBundleFileName() {
        return GradleUtil.toString((Object)this._bundleFileName);
    }

    @Input
    public String getGlobalName() {
        return GradleUtil.toString((Object)this._globalName);
    }

    @Input
    public String getModuleName() {
        return GradleUtil.toString((Object)this._moduleName);
    }

    @Input
    public String getModules() {
        return GradleUtil.toString((Object)this._modules);
    }

    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        File sourceDir = this.getSourceDir();
        if (sourceDir == null) {
            return project.files(new Object[0]);
        }
        ConfigurableFileTree configurableFileTree = project.fileTree((Object)sourceDir);
        configurableFileTree.include(this.getSoySrcIncludes());
        configurableFileTree.include(this.getSrcIncludes());
        return configurableFileTree;
    }

    @Input
    public SourceMaps getSourceMaps() {
        return this._sourceMaps;
    }

    public List<String> getSoySrcIncludes() {
        return GradleUtil.toStringList(this._soySrcIncludes);
    }

    public List<String> getSrcIncludes() {
        return GradleUtil.toStringList(this._srcIncludes);
    }

    @OutputDirectory
    public File getWorkingDir() {
        return super.getWorkingDir();
    }

    @Input
    public boolean isSoySkipMetalGeneration() {
        return this._soySkipMetalGeneration;
    }

    public void setBundleFileName(Object bundleFileName) {
        this._bundleFileName = bundleFileName;
    }

    public void setGlobalName(Object globalName) {
        this._globalName = globalName;
    }

    public void setModuleName(Object moduleName) {
        this._moduleName = moduleName;
    }

    public void setModules(Object modules) {
        this._modules = modules;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setSourceMaps(SourceMaps sourceMaps) {
        this._sourceMaps = sourceMaps;
    }

    public void setSoySkipMetalGeneration(boolean soySkipMetalGeneration) {
        this._soySkipMetalGeneration = soySkipMetalGeneration;
    }

    public void setSoySrcIncludes(Iterable<?> soySrcIncludes) {
        this._soySrcIncludes.clear();
        this.soySrcInclude(soySrcIncludes);
    }

    public void setSoySrcIncludes(Object ... soySrcIncludes) {
        this.setSoySrcIncludes(Arrays.asList(soySrcIncludes));
    }

    public void setSrcIncludes(Iterable<?> srcIncludes) {
        this._srcIncludes.clear();
        this.srcInclude(srcIncludes);
    }

    public void setSrcIncludes(Object ... srcIncludes) {
        this.setSrcIncludes(Arrays.asList(srcIncludes));
    }

    public TranspileJSTask soySrcInclude(Iterable<?> soySrcIncludes) {
        GUtil.addToCollection(this._soySrcIncludes, (Iterable[])new Iterable[]{soySrcIncludes});
        return this;
    }

    public TranspileJSTask soySrcInclude(Object ... soySrcIncludes) {
        return this.soySrcInclude(Arrays.asList(soySrcIncludes));
    }

    public TranspileJSTask srcInclude(Iterable<?> srcIncludes) {
        GUtil.addToCollection(this._srcIncludes, (Iterable[])new Iterable[]{srcIncludes});
        return this;
    }

    public TranspileJSTask srcInclude(Object ... srcIncludes) {
        return this.srcInclude(Arrays.asList(srcIncludes));
    }

    protected List<String> getCompleteArgs() {
        List completeArgs = super.getCompleteArgs();
        String destination = FileUtil.getAbsolutePath((File)this.getWorkingDir());
        completeArgs.add("build");
        completeArgs.add("--bundleFileName");
        completeArgs.add(this.getBundleFileName());
        completeArgs.add("--dest");
        completeArgs.add(destination);
        completeArgs.add("--format");
        completeArgs.add(this.getModules());
        completeArgs.add("--globalName");
        completeArgs.add(this.getGlobalName());
        completeArgs.add("--moduleName");
        completeArgs.add(this.getModuleName());
        SourceMaps sourceMaps = this.getSourceMaps();
        if (sourceMaps != SourceMaps.ENABLED) {
            completeArgs.add("--source-maps");
            if (sourceMaps == SourceMaps.ENABLED_INLINE) {
                completeArgs.add("inline");
            } else {
                completeArgs.add("false");
            }
        }
        completeArgs.add("--soyDest");
        completeArgs.add(destination);
        completeArgs.add("--soySrc");
        for (String soySrcInclude : this.getSoySrcIncludes()) {
            completeArgs.add(soySrcInclude);
        }
        if (this.isSoySkipMetalGeneration()) {
            completeArgs.add("--soySkipMetalGeneration");
        }
        completeArgs.add("--src");
        for (String srcInclude : this.getSrcIncludes()) {
            completeArgs.add(srcInclude);
        }
        return completeArgs;
    }

    public static enum SourceMaps {
        DISABLED,
        ENABLED,
        ENABLED_INLINE;

    }
}

