/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.transpiler;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

public class TranspileJSTask
extends ExecuteNodeTask {
    private Object _modules = "amd";
    private Object _outputDir;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private String _scriptFileName = "node_modules/babel/bin/babel.js";
    private Object _sourceDir;
    private SourceMaps _sourceMaps = SourceMaps.ENABLED;
    private int _stage = 0;

    public TranspileJSTask() {
        this.dependsOn(new Object[]{"downloadBabel"});
        this.dependsOn(new Object[]{"downloadLfrAmdLoader"});
        this.include("**/*.es.js");
    }

    public TranspileJSTask exclude(Closure<?> closure) {
        this._patternFilterable.exclude(closure);
        return this;
    }

    public TranspileJSTask exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public TranspileJSTask exclude(Spec<FileTreeElement> spec) {
        this._patternFilterable.exclude(spec);
        return this;
    }

    public TranspileJSTask exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public void executeNode() {
        this.setArgs(this.getCompleteArgs());
        super.setWorkingDir((Object)this.getWorkingDir());
        super.executeNode();
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    @Input
    public String getModules() {
        return GradleUtil.toString((Object)this._modules);
    }

    @OutputDirectory
    public File getOutputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputDir);
    }

    public String getScriptFileName() {
        return this._scriptFileName;
    }

    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        if (this._sourceDir == null) {
            return project.files(new Object[0]);
        }
        ConfigurableFileTree fileTree = project.fileTree(this._sourceDir);
        return fileTree.matching(this._patternFilterable);
    }

    @Input
    public SourceMaps getSourceMaps() {
        return this._sourceMaps;
    }

    @Input
    public int getStage() {
        return this._stage;
    }

    public File getWorkingDir() {
        return this.getSourceDir();
    }

    public TranspileJSTask include(Closure<?> closure) {
        this._patternFilterable.include(closure);
        return this;
    }

    public TranspileJSTask include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public TranspileJSTask include(Spec<FileTreeElement> spec) {
        this._patternFilterable.include(spec);
        return this;
    }

    public TranspileJSTask include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public TranspileJSTask setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public TranspileJSTask setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setModules(Object modules) {
        this._modules = modules;
    }

    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setScriptFileName(String scriptFileName) {
        this._scriptFileName = scriptFileName;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setSourceMaps(SourceMaps sourceMaps) {
        this._sourceMaps = sourceMaps;
    }

    public void setStage(int stage) {
        this._stage = stage;
    }

    protected List<Object> getCompleteArgs() {
        File sourceDir = this.getSourceDir();
        ArrayList<Object> completeArgs = new ArrayList<Object>();
        File scriptFile = new File(this.getNodeDir(), this.getScriptFileName());
        completeArgs.add(FileUtil.getAbsolutePath((File)scriptFile));
        GUtil.addToCollection(completeArgs, (Iterable[])new Iterable[]{this.getArgs()});
        completeArgs.add("--modules");
        completeArgs.add(this.getModules());
        completeArgs.add("--out-dir");
        completeArgs.add(FileUtil.relativize((File)this.getOutputDir(), (File)sourceDir));
        SourceMaps sourceMaps = this.getSourceMaps();
        if (sourceMaps != SourceMaps.DISABLED) {
            completeArgs.add("--source-maps");
        }
        if (sourceMaps == SourceMaps.ENABLED_INLINE) {
            completeArgs.add("inline");
        }
        completeArgs.add("--stage");
        completeArgs.add(this.getStage());
        for (File file : this.getSourceFiles()) {
            completeArgs.add(FileUtil.relativize((File)file, (File)sourceDir));
        }
        return completeArgs;
    }

    public static enum SourceMaps {
        DISABLED,
        ENABLED,
        ENABLED_INLINE;

    }
}

