/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.transpiler;

import com.liferay.gradle.plugins.js.transpiler.JSTranspilerExtension;
import com.liferay.gradle.plugins.js.transpiler.TranspileJSTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;

public class JSTranspilerPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_BABEL_TASK_NAME = "downloadBabel";
    public static final String DOWNLOAD_LFR_AMD_LOADER_TASK_NAME = "downloadLfrAmdLoader";
    public static final String EXTENSION_NAME = "jsTranspiler";
    public static final String TRANSPILE_JS_TASK_NAME = "transpileJS";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        JSTranspilerExtension jsTranspilerExtension = (JSTranspilerExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, JSTranspilerExtension.class);
        this.addTaskDownloadBabel(project, jsTranspilerExtension);
        this.addTaskDownloadLfrAmdLoader(project, jsTranspilerExtension);
        this.addTaskTranspileJS(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JSTranspilerPlugin.this.configureTasksTranspileJS(project);
            }
        });
    }

    protected DownloadNodeModuleTask addTaskDownloadBabel(Project project, final JSTranspilerExtension jsTranspilerExtension) {
        DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_BABEL_TASK_NAME, DownloadNodeModuleTask.class);
        downloadNodeModuleTask.setModuleName((Object)"babel");
        downloadNodeModuleTask.setModuleVersion((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return jsTranspilerExtension.getBabelVersion();
            }
        });
        return downloadNodeModuleTask;
    }

    protected DownloadNodeModuleTask addTaskDownloadLfrAmdLoader(Project project, final JSTranspilerExtension jsTranspilerExtension) {
        DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_LFR_AMD_LOADER_TASK_NAME, DownloadNodeModuleTask.class);
        downloadNodeModuleTask.setModuleName((Object)"lfr-amd-loader");
        downloadNodeModuleTask.setModuleVersion((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return jsTranspilerExtension.getLfrAmdLoaderVersion();
            }
        });
        return downloadNodeModuleTask;
    }

    protected TranspileJSTask addTaskTranspileJS(Project project) {
        final TranspileJSTask transpileJSTask = (TranspileJSTask)GradleUtil.addTask((Project)project, (String)TRANSPILE_JS_TASK_NAME, TranspileJSTask.class);
        transpileJSTask.setDescription("Transpiles JS files.");
        transpileJSTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JSTranspilerPlugin.this.configureTaskTranspileJSForJavaPlugin(transpileJSTask);
            }
        });
        return transpileJSTask;
    }

    protected void configureTasksTranspileJS(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TranspileJSTask.class, (Action)new Action<TranspileJSTask>(){

            public void execute(TranspileJSTask transpileJSTask) {
                JSTranspilerPlugin.this.configureTaskTranspileJSEnabled(transpileJSTask);
            }
        });
    }

    protected void configureTaskTranspileJSEnabled(TranspileJSTask transpileJSTask) {
        FileCollection fileCollection = transpileJSTask.getSourceFiles();
        if (fileCollection.isEmpty()) {
            transpileJSTask.setDependsOn(Collections.emptySet());
            transpileJSTask.setEnabled(false);
        }
    }

    protected void configureTaskTranspileJSForJavaPlugin(TranspileJSTask transpileJSTask) {
        transpileJSTask.mustRunAfter(new Object[]{"processResources"});
        Project project = transpileJSTask.getProject();
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        transpileJSTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getResourcesDir();
            }
        });
        transpileJSTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return JSTranspilerPlugin.this.getSrcDir(sourceSet.getResources());
            }
        });
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{transpileJSTask});
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

