/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.javadoc.formatter;

import com.liferay.gradle.plugins.javadoc.formatter.FormatJavadocTask;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;

public class JavadocFormatterPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "javadocFormatter";
    public static final String FORMAT_JAVADOC_TASK_NAME = "formatJavadoc";

    public void apply(Project project) {
        Configuration javadocFormatterConfiguration = this.addConfigurationJavadocFormatter(project);
        this.addTaskFormatJavadoc(project);
        this.configureTasksFormatJavadoc(project, javadocFormatterConfiguration);
    }

    protected Configuration addConfigurationJavadocFormatter(final Project project) {
        final Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay Javadoc Formatter for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                JavadocFormatterPlugin.this.addDependenciesJavadocFormatter(project);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavadocFormatterPlugin.this.configureConfigurationJavadocFormatterForJavaPlugin(project, configuration);
            }
        });
        return configuration;
    }

    protected void addDependenciesJavadocFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.javadoc.formatter", (String)"latest.release");
    }

    protected FormatJavadocTask addTaskFormatJavadoc(Project project) {
        FormatJavadocTask formatJavadocTask = (FormatJavadocTask)GradleUtil.addTask((Project)project, (String)FORMAT_JAVADOC_TASK_NAME, FormatJavadocTask.class);
        formatJavadocTask.setDescription("Runs Liferay Javadoc Formatter to format files.");
        return formatJavadocTask;
    }

    protected void configureConfigurationJavadocFormatterForJavaPlugin(Project project, Configuration configuration) {
        Configuration compileConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compile");
        configuration.extendsFrom(new Configuration[]{compileConfiguration});
    }

    protected void configureTaskFormatJavadocClasspath(FormatJavadocTask formatJavadocTask, FileCollection fileCollection) {
        formatJavadocTask.setClasspath(fileCollection);
    }

    protected void configureTasksFormatJavadoc(Project project, final Configuration javadocFormatterConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatJavadocTask.class, (Action)new Action<FormatJavadocTask>(){

            public void execute(FormatJavadocTask formatJavadoc) {
                JavadocFormatterPlugin.this.configureTaskFormatJavadocClasspath(formatJavadoc, (FileCollection)javadocFormatterConfiguration);
            }
        });
    }
}

