/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class JspCPlugin
implements Plugin<Project> {
    public static final String COMPILE_JSP_TASK_NAME = "compileJSP";
    public static final String CONFIGURATION_NAME = "jspC";
    public static final String GENERATE_JSP_JAVA_TASK_NAME = "generateJSPJava";
    public static final String TOOL_CONFIGURATION_NAME = "jspCTool";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration jspCConfiguration = this._addConfigurationJspC(project);
        Configuration jspCToolConfiguration = this._addConfigurationJspCTool(project);
        CompileJSPTask generateJSPJavaTask = this._addTaskGenerateJSPJava(project, jspCConfiguration, jspCToolConfiguration);
        final JavaCompile compileJSPTask = this._addTaskCompileJSP(generateJSPJavaTask, jspCConfiguration, jspCToolConfiguration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCPlugin.this._addDependenciesJspC(project);
                JspCPlugin.this._configureTaskCompileJSP(compileJSPTask);
            }
        });
    }

    private Configuration _addConfigurationJspC(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures the classpath of the JSP compilation tasks.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationJspCTool(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TOOL_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                JspCPlugin.this._addDependenciesJspCTool(project);
            }
        });
        configuration.setDescription("Configures Liferay Jasper JspC for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesJspC(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{jar});
        configurableFileCollection.builtBy(new Object[]{jar});
        dependencyHandler.add(CONFIGURATION_NAME, (Object)configurableFileCollection);
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        dependencyHandler.add(CONFIGURATION_NAME, (Object)sourceSet.getCompileClasspath());
    }

    private void _addDependenciesJspCTool(Project project) {
        GradleUtil.addDependency((Project)project, (String)TOOL_CONFIGURATION_NAME, (String)"org.apache.ant", (String)"ant", (String)"1.9.4");
        GradleUtil.addDependency((Project)project, (String)TOOL_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.jasper.jspc", (String)"latest.release");
    }

    private JavaCompile _addTaskCompileJSP(CompileJSPTask generateJSPJavaTask, Configuration jspCConfiguration, Configuration jspCToolConfiguration) {
        JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)generateJSPJavaTask.getProject(), (String)COMPILE_JSP_TASK_NAME, JavaCompile.class);
        javaCompile.setClasspath(jspCToolConfiguration.plus((FileCollection)jspCConfiguration));
        javaCompile.setDescription("Compile JSP files to check for errors.");
        javaCompile.setGroup("verification");
        javaCompile.setSource((Object)generateJSPJavaTask.getOutputs());
        return javaCompile;
    }

    private CompileJSPTask _addTaskGenerateJSPJava(Project project, Configuration jspCConfiguration, Configuration jspCToolConfiguration) {
        final CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.addTask((Project)project, (String)GENERATE_JSP_JAVA_TASK_NAME, CompileJSPTask.class);
        compileJSPTask.setClasspath((FileCollection)jspCToolConfiguration);
        compileJSPTask.setDescription("Compiles JSP files to Java source files to check for errors.");
        compileJSPTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = compileJSPTask.getProject();
                return new File(project.getBuildDir(), "jspc");
            }
        });
        compileJSPTask.setJspCClasspath((FileCollection)jspCConfiguration);
        compileJSPTask.setWebAppDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)compileJSPTask.getProject(), (String)"main");
                return JspCPlugin.this._getSrcDir(sourceSet.getResources());
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                JspCPlugin.this._configureTaskGenerateJSPJavaForWarPlugin(compileJSPTask);
            }
        });
        return compileJSPTask;
    }

    private void _configureTaskCompileJSP(JavaCompile compileJSPTask) {
        if (compileJSPTask.getDestinationDir() == null) {
            compileJSPTask.setDestinationDir(compileJSPTask.getTemporaryDir());
        }
    }

    private void _configureTaskGenerateJSPJavaForWarPlugin(final CompileJSPTask compileJSPTask) {
        compileJSPTask.setWebAppDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)compileJSPTask.getProject(), WarPluginConvention.class);
                return warPluginConvention.getWebAppDir();
            }
        });
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

