/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;

public class CompileJSPTask
extends JavaExec {
    private static final Logger _logger = Logging.getLogger(CompileJSPTask.class);
    private Object _destinationDir;
    private FileCollection _jspCClasspath;
    private Object _webAppDir;

    public CompileJSPTask() {
        this.setMain("com.liferay.jasper.jspc.JspC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() {
        this.setArgs(this.getCompleteArgs());
        FileCollection jspCClasspath = this.getJspCClasspath();
        if (jspCClasspath != null) {
            String jspClasspath = jspCClasspath.getAsPath();
            this.setStandardInput(new ByteArrayInputStream(jspClasspath.getBytes()));
        }
        OutputStream taskErrorOutput = this.getErrorOutput();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.setErrorOutput(byteArrayOutputStream);
            super.exec();
            String output = byteArrayOutputStream.toString();
            if (output.contains("JasperException")) {
                _logger.error(output);
                throw new GradleException("Unable to compile JSPs");
            }
            if (_logger.isInfoEnabled()) {
                _logger.info(output);
            }
        }
        finally {
            try {
                byteArrayOutputStream.writeTo(taskErrorOutput);
            }
            catch (IOException ioe) {
                throw new GradleException(ioe.getMessage(), (Throwable)ioe);
            }
            this.setErrorOutput(taskErrorOutput);
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @InputFiles
    public FileCollection getJspCClasspath() {
        return this._jspCClasspath;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getJSPFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getWebAppDir());
        ArrayList<String> excludes = new ArrayList<String>(2);
        excludes.add("**/custom_jsps/**/*");
        excludes.add("**/dependencies/**/*");
        args.put("excludes", excludes);
        args.put("include", "**/*.jsp");
        return project.fileTree(args);
    }

    public File getWebAppDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._webAppDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setJspCClasspath(FileCollection jspCClasspath) {
        this._jspCClasspath = jspCClasspath;
    }

    public JavaExec setStandardOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public void setWebAppDir(Object webAppDir) {
        this._webAppDir = webAppDir;
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> completeArgs = new ArrayList<String>(this.getArgs());
        completeArgs.add("-d");
        completeArgs.add(FileUtil.relativize((File)this.getDestinationDir(), (File)this.getWorkingDir()));
        completeArgs.add("-webapp");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getWebAppDir()));
        return completeArgs;
    }
}

