/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.jasper.jspc.JspCExtension;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class JspCPlugin
implements Plugin<Project> {
    public static final String COMPILE_JSP_TASK_NAME = "compileJSP";
    public static final String CONFIGURATION_NAME = "jspC";
    public static final String EXTENSION_NAME = "jspC";
    public static final String GENERATE_JSP_JAVA_TASK_NAME = "generateJSPJava";
    public static final String TOOL_CONFIGURATION_NAME = "jspCTool";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        final JspCExtension jspCExtension = (JspCExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"jspC", JspCExtension.class);
        Configuration jspCConfiguration = this.addJspCConfiguration(project);
        Configuration jspCToolConfiguration = this.addJspCToolConfiguration(project);
        final CompileJSPTask generateJSPJavaTask = this.addTaskGenerateJSPJava(project, jspCConfiguration, jspCToolConfiguration);
        this.addTaskCompileJSP(generateJSPJavaTask, jspCConfiguration, jspCToolConfiguration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCPlugin.this.addJspCDependencies(project);
                JspCPlugin.this.configureJspcExtension(project, jspCExtension);
                jspCExtension.copyTo(generateJSPJavaTask);
            }
        });
    }

    protected Configuration addJspCConfiguration(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"jspC");
        configuration.setDescription("Configures the classpath of the JSP compilation tasks.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addJspCDependencies(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{jar});
        configurableFileCollection.builtBy(new Object[]{jar});
        dependencyHandler.add("jspC", (Object)configurableFileCollection);
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        dependencyHandler.add("jspC", (Object)sourceSet.getOutput());
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"compile");
        dependencyHandler.add("jspC", (Object)configuration);
    }

    protected Configuration addJspCToolConfiguration(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TOOL_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                JspCPlugin.this.addJspCToolDependencies(project);
            }
        });
        configuration.setDescription("Configures Liferay Jasper JspC for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addJspCToolDependencies(Project project) {
        GradleUtil.addDependency((Project)project, (String)TOOL_CONFIGURATION_NAME, (String)"org.apache.ant", (String)"ant", (String)"1.9.4");
        GradleUtil.addDependency((Project)project, (String)TOOL_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.jasper.jspc", (String)"latest.release");
    }

    protected JavaCompile addTaskCompileJSP(CompileJSPTask generateJSPJavaTask, Configuration jspCConfiguration, Configuration jspCToolConfiguration) {
        JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)generateJSPJavaTask.getProject(), (String)COMPILE_JSP_TASK_NAME, JavaCompile.class);
        javaCompile.setClasspath(jspCToolConfiguration.plus((FileCollection)jspCConfiguration));
        javaCompile.setDescription("Compile JSP files to check for errors.");
        javaCompile.setDestinationDir(javaCompile.getTemporaryDir());
        javaCompile.setGroup("verification");
        javaCompile.setSource((Object)generateJSPJavaTask.getOutputs());
        return javaCompile;
    }

    protected CompileJSPTask addTaskGenerateJSPJava(Project project, Configuration jspCConfiguration, Configuration jspCToolConfiguration) {
        CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.addTask((Project)project, (String)GENERATE_JSP_JAVA_TASK_NAME, CompileJSPTask.class);
        compileJSPTask.setClasspath((FileCollection)jspCToolConfiguration);
        compileJSPTask.setDestinationDir(new File(project.getBuildDir(), "jspc"));
        compileJSPTask.setJspCClasspath((FileCollection)jspCConfiguration);
        return compileJSPTask;
    }

    protected void configureJspcExtension(Project project, JspCExtension jspCExtension) {
        this.configureJspCExtensionWebAppDir(project, jspCExtension);
    }

    protected void configureJspCExtensionWebAppDir(Project project, JspCExtension jspCExtension) {
        if (jspCExtension.getWebAppDir() != null) {
            return;
        }
        File webAppDir = null;
        PluginContainer pluginContainer = project.getPlugins();
        if (pluginContainer.hasPlugin(WarPlugin.class)) {
            WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
            webAppDir = warPluginConvention.getWebAppDir();
        } else {
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
            Set srcDirs = sourceDirectorySet.getSrcDirs();
            Iterator iterator = srcDirs.iterator();
            webAppDir = (File)iterator.next();
        }
        jspCExtension.setWebAppDir(webAppDir);
    }
}

