/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.gulp;

import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.tasks.TaskContainer;

public class GulpPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "gulp";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        this.addTaskRuleGulp(project);
    }

    protected ExecuteGulpTask addTaskExecuteGulp(Project project, String taskName) {
        ExecuteGulpTask executeGulpTask = (ExecuteGulpTask)GradleUtil.addTask((Project)project, (String)taskName, ExecuteGulpTask.class);
        char gulpCommandFirstChar = taskName.charAt(4);
        String gulpCommand = Character.toLowerCase(gulpCommandFirstChar) + taskName.substring(5);
        executeGulpTask.setGulpCommand(gulpCommand);
        return executeGulpTask;
    }

    protected void addTaskRuleGulp(final Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.addRule(new Rule(){

            public void apply(String taskName) {
                if (taskName.startsWith(GulpPlugin.EXTENSION_NAME)) {
                    GulpPlugin.this.addTaskExecuteGulp(project, taskName);
                }
            }

            public String getDescription() {
                return "Pattern: gulp<Task>: Executes a named Gulp task.";
            }
        });
    }
}

