/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.go.tasks;

import com.liferay.gradle.plugins.go.GoExtension;
import com.liferay.gradle.plugins.go.internal.GoExecutor;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class DownloadGoTask
extends DefaultTask {
    private final GoExecutor _goExecutor = new GoExecutor(this.getProject());
    private Object _goUrl;

    public DownloadGoTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File goDir = DownloadGoTask.this.getGoDir();
                return goDir == null || !goDir.exists();
            }
        });
        GoExtension goExtension = (GoExtension)GradleUtil.getExtension((ExtensionAware)this.getProject(), GoExtension.class);
        this.setGoDir(goExtension.getGoDir());
        this.setGoUrl(goExtension.getGoUrl());
    }

    @TaskAction
    public void downloadGo() throws IOException {
        final File goDir = this.getGoDir();
        final Project project = this.getProject();
        final File goFile = this._download(this.getGoUrl(), null);
        project.delete(new Object[]{goDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                String goFileName = goFile.getName();
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
                copySpec.setIncludeEmptyDirs(false);
                if (goFileName.endsWith(".zip")) {
                    copySpec.from(new Object[]{project.zipTree((Object)goFile)});
                } else {
                    copySpec.from(new Object[]{project.tarTree((Object)goFile)});
                }
                copySpec.into((Object)goDir);
            }
        });
    }

    @OutputDirectory
    public File getGoDir() {
        return this._goExecutor.getGoDir();
    }

    @Input
    public String getGoUrl() {
        return GradleUtil.toString((Object)this._goUrl);
    }

    public void setGoDir(Object goDir) {
        this._goExecutor.setGoDir(goDir);
    }

    public void setGoUrl(Object goUrl) {
        this._goUrl = goUrl;
    }

    private File _download(String url, File destinationFile) throws IOException {
        String protocol = url.substring(0, url.indexOf(58));
        String proxyPassword = System.getProperty(protocol + ".proxyPassword");
        String proxyUser = System.getProperty(protocol + ".proxyUser");
        if (Validator.isNotNull((String)proxyPassword) && Validator.isNotNull((String)proxyUser)) {
            Project project = this.getProject();
            String nonProxyHosts = System.getProperty(protocol + ".nonProxyHosts");
            String proxyHost = System.getProperty(protocol + ".proxyHost");
            String proxyPort = System.getProperty(protocol + ".proxyPort");
            AntBuilder antBuilder = project.getAnt();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("nonproxyhosts", nonProxyHosts);
            args.put("proxyhost", proxyHost);
            args.put("proxypassword", proxyPassword);
            args.put("proxyport", proxyPort);
            args.put("proxyuser", proxyUser);
            antBuilder.invokeMethod("setproxy", args);
        }
        return FileUtil.get((Project)this.getProject(), (String)url, (File)destinationFile);
    }
}

